/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PodCertificateProjection provides a private key and X.509 certificate in the pod filesystem.")
public class V1PodCertificateProjection {
    public static final String SERIALIZED_NAME_CERTIFICATE_CHAIN_PATH = "certificateChainPath";
    @SerializedName(value="certificateChainPath")
    private String certificateChainPath;
    public static final String SERIALIZED_NAME_CREDENTIAL_BUNDLE_PATH = "credentialBundlePath";
    @SerializedName(value="credentialBundlePath")
    private String credentialBundlePath;
    public static final String SERIALIZED_NAME_KEY_PATH = "keyPath";
    @SerializedName(value="keyPath")
    private String keyPath;
    public static final String SERIALIZED_NAME_KEY_TYPE = "keyType";
    @SerializedName(value="keyType")
    private String keyType;
    public static final String SERIALIZED_NAME_MAX_EXPIRATION_SECONDS = "maxExpirationSeconds";
    @SerializedName(value="maxExpirationSeconds")
    private Integer maxExpirationSeconds;
    public static final String SERIALIZED_NAME_SIGNER_NAME = "signerName";
    @SerializedName(value="signerName")
    private String signerName;

    public V1PodCertificateProjection certificateChainPath(String certificateChainPath) {
        this.certificateChainPath = certificateChainPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Write the certificate chain at this path in the projected volume.  Most applications should use credentialBundlePath.  When using keyPath and certificateChainPath, your application needs to check that the key and leaf certificate are consistent, because it is possible to read the files mid-rotation.")
    public String getCertificateChainPath() {
        return this.certificateChainPath;
    }

    public void setCertificateChainPath(String certificateChainPath) {
        this.certificateChainPath = certificateChainPath;
    }

    public V1PodCertificateProjection credentialBundlePath(String credentialBundlePath) {
        this.credentialBundlePath = credentialBundlePath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Write the credential bundle at this path in the projected volume.  The credential bundle is a single file that contains multiple PEM blocks. The first PEM block is a PRIVATE KEY block, containing a PKCS#8 private key.  The remaining blocks are CERTIFICATE blocks, containing the issued certificate chain from the signer (leaf and any intermediates).  Using credentialBundlePath lets your Pod's application code make a single atomic read that retrieves a consistent key and certificate chain.  If you project them to separate files, your application code will need to additionally check that the leaf certificate was issued to the key.")
    public String getCredentialBundlePath() {
        return this.credentialBundlePath;
    }

    public void setCredentialBundlePath(String credentialBundlePath) {
        this.credentialBundlePath = credentialBundlePath;
    }

    public V1PodCertificateProjection keyPath(String keyPath) {
        this.keyPath = keyPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Write the key at this path in the projected volume.  Most applications should use credentialBundlePath.  When using keyPath and certificateChainPath, your application needs to check that the key and leaf certificate are consistent, because it is possible to read the files mid-rotation.")
    public String getKeyPath() {
        return this.keyPath;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
    }

    public V1PodCertificateProjection keyType(String keyType) {
        this.keyType = keyType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of keypair Kubelet will generate for the pod.  Valid values are \"RSA3072\", \"RSA4096\", \"ECDSAP256\", \"ECDSAP384\", \"ECDSAP521\", and \"ED25519\".")
    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public V1PodCertificateProjection maxExpirationSeconds(Integer maxExpirationSeconds) {
        this.maxExpirationSeconds = maxExpirationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="maxExpirationSeconds is the maximum lifetime permitted for the certificate.  Kubelet copies this value verbatim into the PodCertificateRequests it generates for this projection.  If omitted, kube-apiserver will set it to 86400(24 hours). kube-apiserver will reject values shorter than 3600 (1 hour).  The maximum allowable value is 7862400 (91 days).  The signer implementation is then free to issue a certificate with any lifetime *shorter* than MaxExpirationSeconds, but no shorter than 3600 seconds (1 hour).  This constraint is enforced by kube-apiserver. `kubernetes.io` signers will never issue certificates with a lifetime longer than 24 hours.")
    public Integer getMaxExpirationSeconds() {
        return this.maxExpirationSeconds;
    }

    public void setMaxExpirationSeconds(Integer maxExpirationSeconds) {
        this.maxExpirationSeconds = maxExpirationSeconds;
    }

    public V1PodCertificateProjection signerName(String signerName) {
        this.signerName = signerName;
        return this;
    }

    @ApiModelProperty(required=true, value="Kubelet's generated CSRs will be addressed to this signer.")
    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodCertificateProjection v1PodCertificateProjection = (V1PodCertificateProjection)o;
        return Objects.equals(this.certificateChainPath, v1PodCertificateProjection.certificateChainPath) && Objects.equals(this.credentialBundlePath, v1PodCertificateProjection.credentialBundlePath) && Objects.equals(this.keyPath, v1PodCertificateProjection.keyPath) && Objects.equals(this.keyType, v1PodCertificateProjection.keyType) && Objects.equals(this.maxExpirationSeconds, v1PodCertificateProjection.maxExpirationSeconds) && Objects.equals(this.signerName, v1PodCertificateProjection.signerName);
    }

    public int hashCode() {
        return Objects.hash(this.certificateChainPath, this.credentialBundlePath, this.keyPath, this.keyType, this.maxExpirationSeconds, this.signerName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodCertificateProjection {\n");
        sb.append("    certificateChainPath: ").append(this.toIndentedString(this.certificateChainPath)).append("\n");
        sb.append("    credentialBundlePath: ").append(this.toIndentedString(this.credentialBundlePath)).append("\n");
        sb.append("    keyPath: ").append(this.toIndentedString(this.keyPath)).append("\n");
        sb.append("    keyType: ").append(this.toIndentedString(this.keyType)).append("\n");
        sb.append("    maxExpirationSeconds: ").append(this.toIndentedString(this.maxExpirationSeconds)).append("\n");
        sb.append("    signerName: ").append(this.toIndentedString(this.signerName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

