/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1beta2DeviceSubRequest;
import io.kubernetes.client.openapi.models.V1beta2ExactDeviceRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices. With FirstAvailable it is also possible to provide a prioritized list of requests.")
public class V1beta2DeviceRequest {
    public static final String SERIALIZED_NAME_EXACTLY = "exactly";
    @SerializedName(value="exactly")
    @Nullable
    private V1beta2ExactDeviceRequest exactly;
    public static final String SERIALIZED_NAME_FIRST_AVAILABLE = "firstAvailable";
    @SerializedName(value="firstAvailable")
    @Nullable
    private List<V1beta2DeviceSubRequest> firstAvailable = new ArrayList<V1beta2DeviceSubRequest>();
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta2DeviceRequest exactly(@Nullable V1beta2ExactDeviceRequest exactly) {
        this.exactly = exactly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta2ExactDeviceRequest getExactly() {
        return this.exactly;
    }

    public void setExactly(@Nullable V1beta2ExactDeviceRequest exactly) {
        this.exactly = exactly;
    }

    public V1beta2DeviceRequest firstAvailable(@Nullable List<V1beta2DeviceSubRequest> firstAvailable) {
        this.firstAvailable = firstAvailable;
        return this;
    }

    public V1beta2DeviceRequest addFirstAvailableItem(V1beta2DeviceSubRequest firstAvailableItem) {
        if (this.firstAvailable == null) {
            this.firstAvailable = new ArrayList<V1beta2DeviceSubRequest>();
        }
        this.firstAvailable.add(firstAvailableItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="FirstAvailable contains subrequests, of which exactly one will be selected by the scheduler. It tries to satisfy them in the order in which they are listed here. So if there are two entries in the list, the scheduler will only check the second one if it determines that the first one can not be used.  DRA does not yet implement scoring, so the scheduler will select the first set of devices that satisfies all the requests in the claim. And if the requirements can be satisfied on more than one node, other scheduling features will determine which node is chosen. This means that the set of devices allocated to a claim might not be the optimal set available to the cluster. Scoring will be implemented later.")
    public List<V1beta2DeviceSubRequest> getFirstAvailable() {
        return this.firstAvailable;
    }

    public void setFirstAvailable(@Nullable List<V1beta2DeviceSubRequest> firstAvailable) {
        this.firstAvailable = firstAvailable;
    }

    public V1beta2DeviceRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.  References using the name in the DeviceRequest will uniquely identify a request when the Exactly field is set. When the FirstAvailable field is set, a reference to the name of the DeviceRequest will match whatever subrequest is chosen by the scheduler.  Must be a DNS label.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DeviceRequest v1beta2DeviceRequest = (V1beta2DeviceRequest)o;
        return Objects.equals(this.exactly, v1beta2DeviceRequest.exactly) && Objects.equals(this.firstAvailable, v1beta2DeviceRequest.firstAvailable) && Objects.equals(this.name, v1beta2DeviceRequest.name);
    }

    public int hashCode() {
        return Objects.hash(this.exactly, this.firstAvailable, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2DeviceRequest {\n");
        sb.append("    exactly: ").append(this.toIndentedString(this.exactly)).append("\n");
        sb.append("    firstAvailable: ").append(this.toIndentedString(this.firstAvailable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayfirstAvailable;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta2DeviceRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta2DeviceRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_EXACTLY) != null && !jsonObj.get(SERIALIZED_NAME_EXACTLY).isJsonNull()) {
            V1beta2ExactDeviceRequest.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EXACTLY));
        }
        if (jsonObj.get(SERIALIZED_NAME_FIRST_AVAILABLE) != null && !jsonObj.get(SERIALIZED_NAME_FIRST_AVAILABLE).isJsonNull() && (jsonArrayfirstAvailable = jsonObj.getAsJsonArray(SERIALIZED_NAME_FIRST_AVAILABLE)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FIRST_AVAILABLE).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `firstAvailable` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FIRST_AVAILABLE).toString()));
            }
            for (int i = 0; i < jsonArrayfirstAvailable.size(); ++i) {
                V1beta2DeviceSubRequest.validateJsonElement(jsonArrayfirstAvailable.get(i));
            }
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
    }

    public static V1beta2DeviceRequest fromJson(String jsonString) throws IOException {
        return (V1beta2DeviceRequest)JSON.getGson().fromJson(jsonString, V1beta2DeviceRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EXACTLY);
        openapiFields.add(SERIALIZED_NAME_FIRST_AVAILABLE);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta2DeviceRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta2DeviceRequest.class));
            return new TypeAdapter<V1beta2DeviceRequest>(){

                public void write(JsonWriter out, V1beta2DeviceRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta2DeviceRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta2DeviceRequest.validateJsonElement(jsonElement);
                    return (V1beta2DeviceRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

