/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="LimitRangeItem defines a min/max usage limit for any resource that matches on kind.")
public class V1LimitRangeItem {
    public static final String SERIALIZED_NAME_DEFAULT = "default";
    @SerializedName(value="default")
    @Nullable
    private Map<String, Quantity> _default = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_DEFAULT_REQUEST = "defaultRequest";
    @SerializedName(value="defaultRequest")
    @Nullable
    private Map<String, Quantity> defaultRequest = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_MAX = "max";
    @SerializedName(value="max")
    @Nullable
    private Map<String, Quantity> max = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_MAX_LIMIT_REQUEST_RATIO = "maxLimitRequestRatio";
    @SerializedName(value="maxLimitRequestRatio")
    @Nullable
    private Map<String, Quantity> maxLimitRequestRatio = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_MIN = "min";
    @SerializedName(value="min")
    @Nullable
    private Map<String, Quantity> min = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    @Nonnull
    private String type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1LimitRangeItem _default(@Nullable Map<String, Quantity> _default) {
        this._default = _default;
        return this;
    }

    public V1LimitRangeItem putDefaultItem(String key, Quantity _defaultItem) {
        if (this._default == null) {
            this._default = new HashMap<String, Quantity>();
        }
        this._default.put(key, _defaultItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Default resource requirement limit value by resource name if resource limit is omitted.")
    public Map<String, Quantity> getDefault() {
        return this._default;
    }

    public void setDefault(@Nullable Map<String, Quantity> _default) {
        this._default = _default;
    }

    public V1LimitRangeItem defaultRequest(@Nullable Map<String, Quantity> defaultRequest) {
        this.defaultRequest = defaultRequest;
        return this;
    }

    public V1LimitRangeItem putDefaultRequestItem(String key, Quantity defaultRequestItem) {
        if (this.defaultRequest == null) {
            this.defaultRequest = new HashMap<String, Quantity>();
        }
        this.defaultRequest.put(key, defaultRequestItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.")
    public Map<String, Quantity> getDefaultRequest() {
        return this.defaultRequest;
    }

    public void setDefaultRequest(@Nullable Map<String, Quantity> defaultRequest) {
        this.defaultRequest = defaultRequest;
    }

    public V1LimitRangeItem max(@Nullable Map<String, Quantity> max) {
        this.max = max;
        return this;
    }

    public V1LimitRangeItem putMaxItem(String key, Quantity maxItem) {
        if (this.max == null) {
            this.max = new HashMap<String, Quantity>();
        }
        this.max.put(key, maxItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Max usage constraints on this kind by resource name.")
    public Map<String, Quantity> getMax() {
        return this.max;
    }

    public void setMax(@Nullable Map<String, Quantity> max) {
        this.max = max;
    }

    public V1LimitRangeItem maxLimitRequestRatio(@Nullable Map<String, Quantity> maxLimitRequestRatio) {
        this.maxLimitRequestRatio = maxLimitRequestRatio;
        return this;
    }

    public V1LimitRangeItem putMaxLimitRequestRatioItem(String key, Quantity maxLimitRequestRatioItem) {
        if (this.maxLimitRequestRatio == null) {
            this.maxLimitRequestRatio = new HashMap<String, Quantity>();
        }
        this.maxLimitRequestRatio.put(key, maxLimitRequestRatioItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.")
    public Map<String, Quantity> getMaxLimitRequestRatio() {
        return this.maxLimitRequestRatio;
    }

    public void setMaxLimitRequestRatio(@Nullable Map<String, Quantity> maxLimitRequestRatio) {
        this.maxLimitRequestRatio = maxLimitRequestRatio;
    }

    public V1LimitRangeItem min(@Nullable Map<String, Quantity> min) {
        this.min = min;
        return this;
    }

    public V1LimitRangeItem putMinItem(String key, Quantity minItem) {
        if (this.min == null) {
            this.min = new HashMap<String, Quantity>();
        }
        this.min.put(key, minItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Min usage constraints on this kind by resource name.")
    public Map<String, Quantity> getMin() {
        return this.min;
    }

    public void setMin(@Nullable Map<String, Quantity> min) {
        this.min = min;
    }

    public V1LimitRangeItem type(@Nonnull String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Type of resource that this limit applies to.")
    public String getType() {
        return this.type;
    }

    public void setType(@Nonnull String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LimitRangeItem v1LimitRangeItem = (V1LimitRangeItem)o;
        return Objects.equals(this._default, v1LimitRangeItem._default) && Objects.equals(this.defaultRequest, v1LimitRangeItem.defaultRequest) && Objects.equals(this.max, v1LimitRangeItem.max) && Objects.equals(this.maxLimitRequestRatio, v1LimitRangeItem.maxLimitRequestRatio) && Objects.equals(this.min, v1LimitRangeItem.min) && Objects.equals(this.type, v1LimitRangeItem.type);
    }

    public int hashCode() {
        return Objects.hash(this._default, this.defaultRequest, this.max, this.maxLimitRequestRatio, this.min, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LimitRangeItem {\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    defaultRequest: ").append(this.toIndentedString(this.defaultRequest)).append("\n");
        sb.append("    max: ").append(this.toIndentedString(this.max)).append("\n");
        sb.append("    maxLimitRequestRatio: ").append(this.toIndentedString(this.maxLimitRequestRatio)).append("\n");
        sb.append("    min: ").append(this.toIndentedString(this.min)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1LimitRangeItem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1LimitRangeItem` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static V1LimitRangeItem fromJson(String jsonString) throws IOException {
        return (V1LimitRangeItem)JSON.getGson().fromJson(jsonString, V1LimitRangeItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DEFAULT);
        openapiFields.add(SERIALIZED_NAME_DEFAULT_REQUEST);
        openapiFields.add(SERIALIZED_NAME_MAX);
        openapiFields.add(SERIALIZED_NAME_MAX_LIMIT_REQUEST_RATIO);
        openapiFields.add(SERIALIZED_NAME_MIN);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1LimitRangeItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1LimitRangeItem.class));
            return new TypeAdapter<V1LimitRangeItem>(){

                public void write(JsonWriter out, V1LimitRangeItem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1LimitRangeItem read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1LimitRangeItem.validateJsonElement(jsonElement);
                    return (V1LimitRangeItem)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

