/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="GroupVersion contains the \"group/version\" and \"version\" string of a version. It is made a struct to keep extensibility.")
public class V1GroupVersionForDiscovery {
    public static final String SERIALIZED_NAME_GROUP_VERSION = "groupVersion";
    @SerializedName(value="groupVersion")
    private String groupVersion;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private String version;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1GroupVersionForDiscovery groupVersion(String groupVersion) {
        this.groupVersion = groupVersion;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="groupVersion specifies the API group and version in the form \"group/version\"")
    public String getGroupVersion() {
        return this.groupVersion;
    }

    public void setGroupVersion(String groupVersion) {
        this.groupVersion = groupVersion;
    }

    public V1GroupVersionForDiscovery version(String version) {
        this.version = version;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="version specifies the version in the form of \"version\". This is to save the clients the trouble of splitting the GroupVersion.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1GroupVersionForDiscovery v1GroupVersionForDiscovery = (V1GroupVersionForDiscovery)o;
        return Objects.equals(this.groupVersion, v1GroupVersionForDiscovery.groupVersion) && Objects.equals(this.version, v1GroupVersionForDiscovery.version);
    }

    public int hashCode() {
        return Objects.hash(this.groupVersion, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1GroupVersionForDiscovery {\n");
        sb.append("    groupVersion: ").append(this.toIndentedString(this.groupVersion)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1GroupVersionForDiscovery is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1GroupVersionForDiscovery` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_GROUP_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `groupVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP_VERSION).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION).toString()));
        }
    }

    public static V1GroupVersionForDiscovery fromJson(String jsonString) throws IOException {
        return (V1GroupVersionForDiscovery)JSON.getGson().fromJson(jsonString, V1GroupVersionForDiscovery.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_GROUP_VERSION);
        openapiFields.add(SERIALIZED_NAME_VERSION);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_GROUP_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSION);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1GroupVersionForDiscovery.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1GroupVersionForDiscovery.class));
            return new TypeAdapter<V1GroupVersionForDiscovery>(){

                public void write(JsonWriter out, V1GroupVersionForDiscovery value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1GroupVersionForDiscovery read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1GroupVersionForDiscovery.validateJsonElement(jsonElement);
                    return (V1GroupVersionForDiscovery)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

