/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1TypedLocalObjectReference;
import io.kubernetes.client.openapi.models.V1TypedObjectReference;
import io.kubernetes.client.openapi.models.V1VolumeResourceRequirements;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes")
public class V1PersistentVolumeClaimSpec {
    public static final String SERIALIZED_NAME_ACCESS_MODES = "accessModes";
    @SerializedName(value="accessModes")
    private List<String> accessModes = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DATA_SOURCE = "dataSource";
    @SerializedName(value="dataSource")
    private V1TypedLocalObjectReference dataSource;
    public static final String SERIALIZED_NAME_DATA_SOURCE_REF = "dataSourceRef";
    @SerializedName(value="dataSourceRef")
    private V1TypedObjectReference dataSourceRef;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private V1VolumeResourceRequirements resources;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private V1LabelSelector selector;
    public static final String SERIALIZED_NAME_STORAGE_CLASS_NAME = "storageClassName";
    @SerializedName(value="storageClassName")
    private String storageClassName;
    public static final String SERIALIZED_NAME_VOLUME_ATTRIBUTES_CLASS_NAME = "volumeAttributesClassName";
    @SerializedName(value="volumeAttributesClassName")
    private String volumeAttributesClassName;
    public static final String SERIALIZED_NAME_VOLUME_MODE = "volumeMode";
    @SerializedName(value="volumeMode")
    private String volumeMode;
    public static final String SERIALIZED_NAME_VOLUME_NAME = "volumeName";
    @SerializedName(value="volumeName")
    private String volumeName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PersistentVolumeClaimSpec accessModes(List<String> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public V1PersistentVolumeClaimSpec addAccessModesItem(String accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="accessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1")
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<String> accessModes) {
        this.accessModes = accessModes;
    }

    public V1PersistentVolumeClaimSpec dataSource(V1TypedLocalObjectReference dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1TypedLocalObjectReference getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(V1TypedLocalObjectReference dataSource) {
        this.dataSource = dataSource;
    }

    public V1PersistentVolumeClaimSpec dataSourceRef(V1TypedObjectReference dataSourceRef) {
        this.dataSourceRef = dataSourceRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1TypedObjectReference getDataSourceRef() {
        return this.dataSourceRef;
    }

    public void setDataSourceRef(V1TypedObjectReference dataSourceRef) {
        this.dataSourceRef = dataSourceRef;
    }

    public V1PersistentVolumeClaimSpec resources(V1VolumeResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1VolumeResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(V1VolumeResourceRequirements resources) {
        this.resources = resources;
    }

    public V1PersistentVolumeClaimSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1PersistentVolumeClaimSpec storageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="storageClassName is the name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1")
    public String getStorageClassName() {
        return this.storageClassName;
    }

    public void setStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
    }

    public V1PersistentVolumeClaimSpec volumeAttributesClassName(String volumeAttributesClassName) {
        this.volumeAttributesClassName = volumeAttributesClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeAttributesClassName may be used to set the VolumeAttributesClass used by this claim. If specified, the CSI driver will create or update the volume with the attributes defined in the corresponding VolumeAttributesClass. This has a different purpose than storageClassName, it can be changed after the claim is created. An empty string value means that no VolumeAttributesClass will be applied to the claim but it's not allowed to reset this field to empty string once it is set. If unspecified and the PersistentVolumeClaim is unbound, the default VolumeAttributesClass will be set by the persistentvolume controller if it exists. If the resource referred to by volumeAttributesClass does not exist, this PersistentVolumeClaim will be set to a Pending state, as reflected by the modifyVolumeStatus field, until such as a resource exists. More info: https://kubernetes.io/docs/concepts/storage/volume-attributes-classes/ (Beta) Using this field requires the VolumeAttributesClass feature gate to be enabled (off by default).")
    public String getVolumeAttributesClassName() {
        return this.volumeAttributesClassName;
    }

    public void setVolumeAttributesClassName(String volumeAttributesClassName) {
        this.volumeAttributesClassName = volumeAttributesClassName;
    }

    public V1PersistentVolumeClaimSpec volumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.")
    public String getVolumeMode() {
        return this.volumeMode;
    }

    public void setVolumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
    }

    public V1PersistentVolumeClaimSpec volumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeName is the binding reference to the PersistentVolume backing this claim.")
    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PersistentVolumeClaimSpec v1PersistentVolumeClaimSpec = (V1PersistentVolumeClaimSpec)o;
        return Objects.equals(this.accessModes, v1PersistentVolumeClaimSpec.accessModes) && Objects.equals(this.dataSource, v1PersistentVolumeClaimSpec.dataSource) && Objects.equals(this.dataSourceRef, v1PersistentVolumeClaimSpec.dataSourceRef) && Objects.equals(this.resources, v1PersistentVolumeClaimSpec.resources) && Objects.equals(this.selector, v1PersistentVolumeClaimSpec.selector) && Objects.equals(this.storageClassName, v1PersistentVolumeClaimSpec.storageClassName) && Objects.equals(this.volumeAttributesClassName, v1PersistentVolumeClaimSpec.volumeAttributesClassName) && Objects.equals(this.volumeMode, v1PersistentVolumeClaimSpec.volumeMode) && Objects.equals(this.volumeName, v1PersistentVolumeClaimSpec.volumeName);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.dataSource, this.dataSourceRef, this.resources, this.selector, this.storageClassName, this.volumeAttributesClassName, this.volumeMode, this.volumeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PersistentVolumeClaimSpec {\n");
        sb.append("    accessModes: ").append(this.toIndentedString(this.accessModes)).append("\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    dataSourceRef: ").append(this.toIndentedString(this.dataSourceRef)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    storageClassName: ").append(this.toIndentedString(this.storageClassName)).append("\n");
        sb.append("    volumeAttributesClassName: ").append(this.toIndentedString(this.volumeAttributesClassName)).append("\n");
        sb.append("    volumeMode: ").append(this.toIndentedString(this.volumeMode)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PersistentVolumeClaimSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PersistentVolumeClaimSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ACCESS_MODES) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS_MODES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCESS_MODES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `accessModes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESS_MODES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DATA_SOURCE) != null && !jsonObj.get(SERIALIZED_NAME_DATA_SOURCE).isJsonNull()) {
            V1TypedLocalObjectReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DATA_SOURCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_DATA_SOURCE_REF) != null && !jsonObj.get(SERIALIZED_NAME_DATA_SOURCE_REF).isJsonNull()) {
            V1TypedObjectReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DATA_SOURCE_REF));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonNull()) {
            V1VolumeResourceRequirements.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCES));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_SELECTOR).isJsonNull()) {
            V1LabelSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SELECTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORAGE_CLASS_NAME) != null && !jsonObj.get(SERIALIZED_NAME_STORAGE_CLASS_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STORAGE_CLASS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `storageClassName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORAGE_CLASS_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUME_ATTRIBUTES_CLASS_NAME) != null && !jsonObj.get(SERIALIZED_NAME_VOLUME_ATTRIBUTES_CLASS_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUME_ATTRIBUTES_CLASS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumeAttributesClassName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_ATTRIBUTES_CLASS_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUME_MODE) != null && !jsonObj.get(SERIALIZED_NAME_VOLUME_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUME_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumeMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_VOLUME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumeName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_NAME).toString()));
        }
    }

    public static V1PersistentVolumeClaimSpec fromJson(String jsonString) throws IOException {
        return (V1PersistentVolumeClaimSpec)JSON.getGson().fromJson(jsonString, V1PersistentVolumeClaimSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCESS_MODES);
        openapiFields.add(SERIALIZED_NAME_DATA_SOURCE);
        openapiFields.add(SERIALIZED_NAME_DATA_SOURCE_REF);
        openapiFields.add(SERIALIZED_NAME_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_STORAGE_CLASS_NAME);
        openapiFields.add(SERIALIZED_NAME_VOLUME_ATTRIBUTES_CLASS_NAME);
        openapiFields.add(SERIALIZED_NAME_VOLUME_MODE);
        openapiFields.add(SERIALIZED_NAME_VOLUME_NAME);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PersistentVolumeClaimSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PersistentVolumeClaimSpec.class));
            return new TypeAdapter<V1PersistentVolumeClaimSpec>(){

                public void write(JsonWriter out, V1PersistentVolumeClaimSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PersistentVolumeClaimSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PersistentVolumeClaimSpec.validateJsonElement(jsonElement);
                    return (V1PersistentVolumeClaimSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

