/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1SecretReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Represents storage that is managed by an external CSI volume driver (Beta feature)")
public class V1CSIPersistentVolumeSource {
    public static final String SERIALIZED_NAME_CONTROLLER_EXPAND_SECRET_REF = "controllerExpandSecretRef";
    @SerializedName(value="controllerExpandSecretRef")
    private V1SecretReference controllerExpandSecretRef;
    public static final String SERIALIZED_NAME_CONTROLLER_PUBLISH_SECRET_REF = "controllerPublishSecretRef";
    @SerializedName(value="controllerPublishSecretRef")
    private V1SecretReference controllerPublishSecretRef;
    public static final String SERIALIZED_NAME_DRIVER = "driver";
    @SerializedName(value="driver")
    private String driver;
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_NODE_EXPAND_SECRET_REF = "nodeExpandSecretRef";
    @SerializedName(value="nodeExpandSecretRef")
    private V1SecretReference nodeExpandSecretRef;
    public static final String SERIALIZED_NAME_NODE_PUBLISH_SECRET_REF = "nodePublishSecretRef";
    @SerializedName(value="nodePublishSecretRef")
    private V1SecretReference nodePublishSecretRef;
    public static final String SERIALIZED_NAME_NODE_STAGE_SECRET_REF = "nodeStageSecretRef";
    @SerializedName(value="nodeStageSecretRef")
    private V1SecretReference nodeStageSecretRef;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_VOLUME_ATTRIBUTES = "volumeAttributes";
    @SerializedName(value="volumeAttributes")
    private Map<String, String> volumeAttributes = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_VOLUME_HANDLE = "volumeHandle";
    @SerializedName(value="volumeHandle")
    private String volumeHandle;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1CSIPersistentVolumeSource controllerExpandSecretRef(V1SecretReference controllerExpandSecretRef) {
        this.controllerExpandSecretRef = controllerExpandSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretReference getControllerExpandSecretRef() {
        return this.controllerExpandSecretRef;
    }

    public void setControllerExpandSecretRef(V1SecretReference controllerExpandSecretRef) {
        this.controllerExpandSecretRef = controllerExpandSecretRef;
    }

    public V1CSIPersistentVolumeSource controllerPublishSecretRef(V1SecretReference controllerPublishSecretRef) {
        this.controllerPublishSecretRef = controllerPublishSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretReference getControllerPublishSecretRef() {
        return this.controllerPublishSecretRef;
    }

    public void setControllerPublishSecretRef(V1SecretReference controllerPublishSecretRef) {
        this.controllerPublishSecretRef = controllerPublishSecretRef;
    }

    public V1CSIPersistentVolumeSource driver(String driver) {
        this.driver = driver;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="driver is the name of the driver to use for this volume. Required.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public V1CSIPersistentVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fsType to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\".")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1CSIPersistentVolumeSource nodeExpandSecretRef(V1SecretReference nodeExpandSecretRef) {
        this.nodeExpandSecretRef = nodeExpandSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretReference getNodeExpandSecretRef() {
        return this.nodeExpandSecretRef;
    }

    public void setNodeExpandSecretRef(V1SecretReference nodeExpandSecretRef) {
        this.nodeExpandSecretRef = nodeExpandSecretRef;
    }

    public V1CSIPersistentVolumeSource nodePublishSecretRef(V1SecretReference nodePublishSecretRef) {
        this.nodePublishSecretRef = nodePublishSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretReference getNodePublishSecretRef() {
        return this.nodePublishSecretRef;
    }

    public void setNodePublishSecretRef(V1SecretReference nodePublishSecretRef) {
        this.nodePublishSecretRef = nodePublishSecretRef;
    }

    public V1CSIPersistentVolumeSource nodeStageSecretRef(V1SecretReference nodeStageSecretRef) {
        this.nodeStageSecretRef = nodeStageSecretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretReference getNodeStageSecretRef() {
        return this.nodeStageSecretRef;
    }

    public void setNodeStageSecretRef(V1SecretReference nodeStageSecretRef) {
        this.nodeStageSecretRef = nodeStageSecretRef;
    }

    public V1CSIPersistentVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readOnly value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write).")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1CSIPersistentVolumeSource volumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes;
        return this;
    }

    public V1CSIPersistentVolumeSource putVolumeAttributesItem(String key, String volumeAttributesItem) {
        if (this.volumeAttributes == null) {
            this.volumeAttributes = new HashMap<String, String>();
        }
        this.volumeAttributes.put(key, volumeAttributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeAttributes of the volume to publish.")
    public Map<String, String> getVolumeAttributes() {
        return this.volumeAttributes;
    }

    public void setVolumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes;
    }

    public V1CSIPersistentVolumeSource volumeHandle(String volumeHandle) {
        this.volumeHandle = volumeHandle;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="volumeHandle is the unique volume name returned by the CSI volume plugin\u2019s CreateVolume to refer to the volume on all subsequent calls. Required.")
    public String getVolumeHandle() {
        return this.volumeHandle;
    }

    public void setVolumeHandle(String volumeHandle) {
        this.volumeHandle = volumeHandle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CSIPersistentVolumeSource v1CSIPersistentVolumeSource = (V1CSIPersistentVolumeSource)o;
        return Objects.equals(this.controllerExpandSecretRef, v1CSIPersistentVolumeSource.controllerExpandSecretRef) && Objects.equals(this.controllerPublishSecretRef, v1CSIPersistentVolumeSource.controllerPublishSecretRef) && Objects.equals(this.driver, v1CSIPersistentVolumeSource.driver) && Objects.equals(this.fsType, v1CSIPersistentVolumeSource.fsType) && Objects.equals(this.nodeExpandSecretRef, v1CSIPersistentVolumeSource.nodeExpandSecretRef) && Objects.equals(this.nodePublishSecretRef, v1CSIPersistentVolumeSource.nodePublishSecretRef) && Objects.equals(this.nodeStageSecretRef, v1CSIPersistentVolumeSource.nodeStageSecretRef) && Objects.equals(this.readOnly, v1CSIPersistentVolumeSource.readOnly) && Objects.equals(this.volumeAttributes, v1CSIPersistentVolumeSource.volumeAttributes) && Objects.equals(this.volumeHandle, v1CSIPersistentVolumeSource.volumeHandle);
    }

    public int hashCode() {
        return Objects.hash(this.controllerExpandSecretRef, this.controllerPublishSecretRef, this.driver, this.fsType, this.nodeExpandSecretRef, this.nodePublishSecretRef, this.nodeStageSecretRef, this.readOnly, this.volumeAttributes, this.volumeHandle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CSIPersistentVolumeSource {\n");
        sb.append("    controllerExpandSecretRef: ").append(this.toIndentedString(this.controllerExpandSecretRef)).append("\n");
        sb.append("    controllerPublishSecretRef: ").append(this.toIndentedString(this.controllerPublishSecretRef)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    nodeExpandSecretRef: ").append(this.toIndentedString(this.nodeExpandSecretRef)).append("\n");
        sb.append("    nodePublishSecretRef: ").append(this.toIndentedString(this.nodePublishSecretRef)).append("\n");
        sb.append("    nodeStageSecretRef: ").append(this.toIndentedString(this.nodeStageSecretRef)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    volumeAttributes: ").append(this.toIndentedString(this.volumeAttributes)).append("\n");
        sb.append("    volumeHandle: ").append(this.toIndentedString(this.volumeHandle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1CSIPersistentVolumeSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1CSIPersistentVolumeSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONTROLLER_EXPAND_SECRET_REF) != null && !jsonObj.get(SERIALIZED_NAME_CONTROLLER_EXPAND_SECRET_REF).isJsonNull()) {
            V1SecretReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONTROLLER_EXPAND_SECRET_REF));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTROLLER_PUBLISH_SECRET_REF) != null && !jsonObj.get(SERIALIZED_NAME_CONTROLLER_PUBLISH_SECRET_REF).isJsonNull()) {
            V1SecretReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONTROLLER_PUBLISH_SECRET_REF));
        }
        if (!jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `driver` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FS_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_FS_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FS_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fsType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FS_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_EXPAND_SECRET_REF) != null && !jsonObj.get(SERIALIZED_NAME_NODE_EXPAND_SECRET_REF).isJsonNull()) {
            V1SecretReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NODE_EXPAND_SECRET_REF));
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_PUBLISH_SECRET_REF) != null && !jsonObj.get(SERIALIZED_NAME_NODE_PUBLISH_SECRET_REF).isJsonNull()) {
            V1SecretReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NODE_PUBLISH_SECRET_REF));
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_STAGE_SECRET_REF) != null && !jsonObj.get(SERIALIZED_NAME_NODE_STAGE_SECRET_REF).isJsonNull()) {
            V1SecretReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NODE_STAGE_SECRET_REF));
        }
        if (!jsonObj.get(SERIALIZED_NAME_VOLUME_HANDLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumeHandle` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_HANDLE).toString()));
        }
    }

    public static V1CSIPersistentVolumeSource fromJson(String jsonString) throws IOException {
        return (V1CSIPersistentVolumeSource)JSON.getGson().fromJson(jsonString, V1CSIPersistentVolumeSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTROLLER_EXPAND_SECRET_REF);
        openapiFields.add(SERIALIZED_NAME_CONTROLLER_PUBLISH_SECRET_REF);
        openapiFields.add(SERIALIZED_NAME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_FS_TYPE);
        openapiFields.add(SERIALIZED_NAME_NODE_EXPAND_SECRET_REF);
        openapiFields.add(SERIALIZED_NAME_NODE_PUBLISH_SECRET_REF);
        openapiFields.add(SERIALIZED_NAME_NODE_STAGE_SECRET_REF);
        openapiFields.add(SERIALIZED_NAME_READ_ONLY);
        openapiFields.add(SERIALIZED_NAME_VOLUME_ATTRIBUTES);
        openapiFields.add(SERIALIZED_NAME_VOLUME_HANDLE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DRIVER);
        openapiRequiredFields.add(SERIALIZED_NAME_VOLUME_HANDLE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1CSIPersistentVolumeSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1CSIPersistentVolumeSource.class));
            return new TypeAdapter<V1CSIPersistentVolumeSource>(){

                public void write(JsonWriter out, V1CSIPersistentVolumeSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1CSIPersistentVolumeSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1CSIPersistentVolumeSource.validateJsonElement(jsonElement);
                    return (V1CSIPersistentVolumeSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

