/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1alpha1MigrationCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Status of the storage version migration.")
public class V1alpha1StorageVersionMigrationStatus {
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1alpha1MigrationCondition> conditions = null;
    public static final String SERIALIZED_NAME_RESOURCE_VERSION = "resourceVersion";
    @SerializedName(value="resourceVersion")
    private String resourceVersion;

    public V1alpha1StorageVersionMigrationStatus conditions(List<V1alpha1MigrationCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1alpha1StorageVersionMigrationStatus addConditionsItem(V1alpha1MigrationCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1alpha1MigrationCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The latest available observations of the migration's current state.")
    public List<V1alpha1MigrationCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1alpha1MigrationCondition> conditions) {
        this.conditions = conditions;
    }

    public V1alpha1StorageVersionMigrationStatus resourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceVersion to compare with the GC cache for performing the migration. This is the current resource version of given group, version and resource when kube-controller-manager first observes this StorageVersionMigration resource.")
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1StorageVersionMigrationStatus v1alpha1StorageVersionMigrationStatus = (V1alpha1StorageVersionMigrationStatus)o;
        return Objects.equals(this.conditions, v1alpha1StorageVersionMigrationStatus.conditions) && Objects.equals(this.resourceVersion, v1alpha1StorageVersionMigrationStatus.resourceVersion);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.resourceVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1StorageVersionMigrationStatus {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    resourceVersion: ").append(this.toIndentedString(this.resourceVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

