/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1alpha2ResourceHandle;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="AllocationResult contains attributes of an allocated resource.")
public class V1alpha2AllocationResult {
    public static final String SERIALIZED_NAME_AVAILABLE_ON_NODES = "availableOnNodes";
    @SerializedName(value="availableOnNodes")
    private V1NodeSelector availableOnNodes;
    public static final String SERIALIZED_NAME_RESOURCE_HANDLES = "resourceHandles";
    @SerializedName(value="resourceHandles")
    private List<V1alpha2ResourceHandle> resourceHandles = null;
    public static final String SERIALIZED_NAME_SHAREABLE = "shareable";
    @SerializedName(value="shareable")
    private Boolean shareable;

    public V1alpha2AllocationResult availableOnNodes(V1NodeSelector availableOnNodes) {
        this.availableOnNodes = availableOnNodes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeSelector getAvailableOnNodes() {
        return this.availableOnNodes;
    }

    public void setAvailableOnNodes(V1NodeSelector availableOnNodes) {
        this.availableOnNodes = availableOnNodes;
    }

    public V1alpha2AllocationResult resourceHandles(List<V1alpha2ResourceHandle> resourceHandles) {
        this.resourceHandles = resourceHandles;
        return this;
    }

    public V1alpha2AllocationResult addResourceHandlesItem(V1alpha2ResourceHandle resourceHandlesItem) {
        if (this.resourceHandles == null) {
            this.resourceHandles = new ArrayList<V1alpha2ResourceHandle>();
        }
        this.resourceHandles.add(resourceHandlesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceHandles contain the state associated with an allocation that should be maintained throughout the lifetime of a claim. Each ResourceHandle contains data that should be passed to a specific kubelet plugin once it lands on a node. This data is returned by the driver after a successful allocation and is opaque to Kubernetes. Driver documentation may explain to users how to interpret this data if needed.  Setting this field is optional. It has a maximum size of 32 entries. If null (or empty), it is assumed this allocation will be processed by a single kubelet plugin with no ResourceHandle data attached. The name of the kubelet plugin invoked will match the DriverName set in the ResourceClaimStatus this AllocationResult is embedded in.")
    public List<V1alpha2ResourceHandle> getResourceHandles() {
        return this.resourceHandles;
    }

    public void setResourceHandles(List<V1alpha2ResourceHandle> resourceHandles) {
        this.resourceHandles = resourceHandles;
    }

    public V1alpha2AllocationResult shareable(Boolean shareable) {
        this.shareable = shareable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shareable determines whether the resource supports more than one consumer at a time.")
    public Boolean getShareable() {
        return this.shareable;
    }

    public void setShareable(Boolean shareable) {
        this.shareable = shareable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2AllocationResult v1alpha2AllocationResult = (V1alpha2AllocationResult)o;
        return Objects.equals(this.availableOnNodes, v1alpha2AllocationResult.availableOnNodes) && Objects.equals(this.resourceHandles, v1alpha2AllocationResult.resourceHandles) && Objects.equals(this.shareable, v1alpha2AllocationResult.shareable);
    }

    public int hashCode() {
        return Objects.hash(this.availableOnNodes, this.resourceHandles, this.shareable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2AllocationResult {\n");
        sb.append("    availableOnNodes: ").append(this.toIndentedString(this.availableOnNodes)).append("\n");
        sb.append("    resourceHandles: ").append(this.toIndentedString(this.resourceHandles)).append("\n");
        sb.append("    shareable: ").append(this.toIndentedString(this.shareable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

