/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ClaimSource describes a reference to a ResourceClaim.  Exactly one of these fields should be set.  Consumers of this type must treat an empty object as if it has an unknown value.")
public class V1ClaimSource {
    public static final String SERIALIZED_NAME_RESOURCE_CLAIM_NAME = "resourceClaimName";
    @SerializedName(value="resourceClaimName")
    private String resourceClaimName;
    public static final String SERIALIZED_NAME_RESOURCE_CLAIM_TEMPLATE_NAME = "resourceClaimTemplateName";
    @SerializedName(value="resourceClaimTemplateName")
    private String resourceClaimTemplateName;

    public V1ClaimSource resourceClaimName(String resourceClaimName) {
        this.resourceClaimName = resourceClaimName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.")
    public String getResourceClaimName() {
        return this.resourceClaimName;
    }

    public void setResourceClaimName(String resourceClaimName) {
        this.resourceClaimName = resourceClaimName;
    }

    public V1ClaimSource resourceClaimTemplateName(String resourceClaimTemplateName) {
        this.resourceClaimTemplateName = resourceClaimTemplateName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod.  The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The pod name and resource name, along with a generated component, will be used to form a unique name for the ResourceClaim, which will be recorded in pod.status.resourceClaimStatuses.  This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.")
    public String getResourceClaimTemplateName() {
        return this.resourceClaimTemplateName;
    }

    public void setResourceClaimTemplateName(String resourceClaimTemplateName) {
        this.resourceClaimTemplateName = resourceClaimTemplateName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ClaimSource v1ClaimSource = (V1ClaimSource)o;
        return Objects.equals(this.resourceClaimName, v1ClaimSource.resourceClaimName) && Objects.equals(this.resourceClaimTemplateName, v1ClaimSource.resourceClaimTemplateName);
    }

    public int hashCode() {
        return Objects.hash(this.resourceClaimName, this.resourceClaimTemplateName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ClaimSource {\n");
        sb.append("    resourceClaimName: ").append(this.toIndentedString(this.resourceClaimName)).append("\n");
        sb.append("    resourceClaimTemplateName: ").append(this.toIndentedString(this.resourceClaimTemplateName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

