/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.RuntimeRawExtension;
import io.kubernetes.client.models.V1ObjectMeta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.")
public class V1ControllerRevision {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="data")
    private RuntimeRawExtension data = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata = null;
    @SerializedName(value="revision")
    private Long revision = null;

    public V1ControllerRevision apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1ControllerRevision data(RuntimeRawExtension data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(value="Data is the serialized representation of the state.")
    public RuntimeRawExtension getData() {
        return this.data;
    }

    public void setData(RuntimeRawExtension data) {
        this.data = data;
    }

    public V1ControllerRevision kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1ControllerRevision metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1ControllerRevision revision(Long revision) {
        this.revision = revision;
        return this;
    }

    @ApiModelProperty(required=true, value="Revision indicates the revision of the state represented by Data.")
    public Long getRevision() {
        return this.revision;
    }

    public void setRevision(Long revision) {
        this.revision = revision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ControllerRevision v1ControllerRevision = (V1ControllerRevision)o;
        return Objects.equals(this.apiVersion, v1ControllerRevision.apiVersion) && Objects.equals(this.data, v1ControllerRevision.data) && Objects.equals(this.kind, v1ControllerRevision.kind) && Objects.equals(this.metadata, v1ControllerRevision.metadata) && Objects.equals(this.revision, v1ControllerRevision.revision);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.data, this.kind, this.metadata, this.revision);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ControllerRevision {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

