/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.")
public class V1CustomResourceSubresourceScale {
    public static final String SERIALIZED_NAME_LABEL_SELECTOR_PATH = "labelSelectorPath";
    @SerializedName(value="labelSelectorPath")
    private String labelSelectorPath;
    public static final String SERIALIZED_NAME_SPEC_REPLICAS_PATH = "specReplicasPath";
    @SerializedName(value="specReplicasPath")
    private String specReplicasPath;
    public static final String SERIALIZED_NAME_STATUS_REPLICAS_PATH = "statusReplicasPath";
    @SerializedName(value="statusReplicasPath")
    private String statusReplicasPath;

    public V1CustomResourceSubresourceScale labelSelectorPath(String labelSelectorPath) {
        this.labelSelectorPath = labelSelectorPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale `status.selector`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status` or `.spec`. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the `status.selector` value in the `/scale` subresource will default to the empty string.")
    public String getLabelSelectorPath() {
        return this.labelSelectorPath;
    }

    public void setLabelSelectorPath(String labelSelectorPath) {
        this.labelSelectorPath = labelSelectorPath;
    }

    public V1CustomResourceSubresourceScale specReplicasPath(String specReplicasPath) {
        this.specReplicasPath = specReplicasPath;
        return this;
    }

    @ApiModelProperty(required=true, value="specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `spec.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.spec`. If there is no value under the given path in the custom resource, the `/scale` subresource will return an error on GET.")
    public String getSpecReplicasPath() {
        return this.specReplicasPath;
    }

    public void setSpecReplicasPath(String specReplicasPath) {
        this.specReplicasPath = specReplicasPath;
    }

    public V1CustomResourceSubresourceScale statusReplicasPath(String statusReplicasPath) {
        this.statusReplicasPath = statusReplicasPath;
        return this;
    }

    @ApiModelProperty(required=true, value="statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `status.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status`. If there is no value under the given path in the custom resource, the `status.replicas` value in the `/scale` subresource will default to 0.")
    public String getStatusReplicasPath() {
        return this.statusReplicasPath;
    }

    public void setStatusReplicasPath(String statusReplicasPath) {
        this.statusReplicasPath = statusReplicasPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CustomResourceSubresourceScale v1CustomResourceSubresourceScale = (V1CustomResourceSubresourceScale)o;
        return Objects.equals(this.labelSelectorPath, v1CustomResourceSubresourceScale.labelSelectorPath) && Objects.equals(this.specReplicasPath, v1CustomResourceSubresourceScale.specReplicasPath) && Objects.equals(this.statusReplicasPath, v1CustomResourceSubresourceScale.statusReplicasPath);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelectorPath, this.specReplicasPath, this.statusReplicasPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CustomResourceSubresourceScale {\n");
        sb.append("    labelSelectorPath: ").append(this.toIndentedString(this.labelSelectorPath)).append("\n");
        sb.append("    specReplicasPath: ").append(this.toIndentedString(this.specReplicasPath)).append("\n");
        sb.append("    statusReplicasPath: ").append(this.toIndentedString(this.statusReplicasPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

