/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1beta1Endpoint;
import io.kubernetes.client.openapi.models.V1beta1EndpointBuilder;
import io.kubernetes.client.openapi.models.V1beta1EndpointFluentImpl;
import io.kubernetes.client.openapi.models.V1beta1EndpointPort;
import io.kubernetes.client.openapi.models.V1beta1EndpointPortBuilder;
import io.kubernetes.client.openapi.models.V1beta1EndpointPortFluentImpl;
import io.kubernetes.client.openapi.models.V1beta1EndpointSlice;
import io.kubernetes.client.openapi.models.V1beta1EndpointSliceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class V1beta1EndpointSliceFluentImpl<A extends V1beta1EndpointSliceFluent<A>>
extends BaseFluent<A>
implements V1beta1EndpointSliceFluent<A> {
    private String addressType;
    private String apiVersion;
    private List<V1beta1EndpointBuilder> endpoints;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private List<V1beta1EndpointPortBuilder> ports;

    public V1beta1EndpointSliceFluentImpl() {
    }

    public V1beta1EndpointSliceFluentImpl(V1beta1EndpointSlice instance) {
        this.withAddressType(instance.getAddressType());
        this.withApiVersion(instance.getApiVersion());
        this.withEndpoints(instance.getEndpoints());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withPorts(instance.getPorts());
    }

    @Override
    public String getAddressType() {
        return this.addressType;
    }

    @Override
    public A withAddressType(String addressType) {
        this.addressType = addressType;
        return (A)this;
    }

    @Override
    public Boolean hasAddressType() {
        return this.addressType != null;
    }

    @Override
    public A withNewAddressType(String arg1) {
        return this.withAddressType(new String(arg1));
    }

    @Override
    public A withNewAddressType(StringBuilder arg1) {
        return this.withAddressType(new String(arg1));
    }

    @Override
    public A withNewAddressType(StringBuffer arg1) {
        return this.withAddressType(new String(arg1));
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToEndpoints(int index, V1beta1Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<V1beta1EndpointBuilder>();
        }
        V1beta1EndpointBuilder builder = new V1beta1EndpointBuilder(item);
        this._visitables.get("endpoints").add(index >= 0 ? index : this._visitables.get("endpoints").size(), builder);
        this.endpoints.add(index >= 0 ? index : this.endpoints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEndpoints(int index, V1beta1Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<V1beta1EndpointBuilder>();
        }
        V1beta1EndpointBuilder builder = new V1beta1EndpointBuilder(item);
        if (index < 0 || index >= this._visitables.get("endpoints").size()) {
            this._visitables.get("endpoints").add(builder);
        } else {
            this._visitables.get("endpoints").set(index, builder);
        }
        if (index < 0 || index >= this.endpoints.size()) {
            this.endpoints.add(builder);
        } else {
            this.endpoints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEndpoints(V1beta1Endpoint ... items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<V1beta1EndpointBuilder>();
        }
        for (V1beta1Endpoint item : items) {
            V1beta1EndpointBuilder builder = new V1beta1EndpointBuilder(item);
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEndpoints(Collection<V1beta1Endpoint> items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<V1beta1EndpointBuilder>();
        }
        for (V1beta1Endpoint item : items) {
            V1beta1EndpointBuilder builder = new V1beta1EndpointBuilder(item);
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEndpoints(V1beta1Endpoint ... items) {
        for (V1beta1Endpoint item : items) {
            V1beta1EndpointBuilder builder = new V1beta1EndpointBuilder(item);
            this._visitables.get("endpoints").remove(builder);
            if (this.endpoints == null) continue;
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEndpoints(Collection<V1beta1Endpoint> items) {
        for (V1beta1Endpoint item : items) {
            V1beta1EndpointBuilder builder = new V1beta1EndpointBuilder(item);
            this._visitables.get("endpoints").remove(builder);
            if (this.endpoints == null) continue;
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEndpoints(Predicate<V1beta1EndpointBuilder> predicate) {
        if (this.endpoints == null) {
            return (A)this;
        }
        Iterator<V1beta1EndpointBuilder> each = this.endpoints.iterator();
        Object visitables = this._visitables.get("endpoints");
        while (each.hasNext()) {
            V1beta1EndpointBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1beta1Endpoint> getEndpoints() {
        return V1beta1EndpointSliceFluentImpl.build(this.endpoints);
    }

    @Override
    public List<V1beta1Endpoint> buildEndpoints() {
        return V1beta1EndpointSliceFluentImpl.build(this.endpoints);
    }

    @Override
    public V1beta1Endpoint buildEndpoint(int index) {
        return this.endpoints.get(index).build();
    }

    @Override
    public V1beta1Endpoint buildFirstEndpoint() {
        return this.endpoints.get(0).build();
    }

    @Override
    public V1beta1Endpoint buildLastEndpoint() {
        return this.endpoints.get(this.endpoints.size() - 1).build();
    }

    @Override
    public V1beta1Endpoint buildMatchingEndpoint(Predicate<V1beta1EndpointBuilder> predicate) {
        for (V1beta1EndpointBuilder item : this.endpoints) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEndpoint(Predicate<V1beta1EndpointBuilder> predicate) {
        for (V1beta1EndpointBuilder item : this.endpoints) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEndpoints(List<V1beta1Endpoint> endpoints) {
        if (this.endpoints != null) {
            this._visitables.get("endpoints").removeAll(this.endpoints);
        }
        if (endpoints != null) {
            this.endpoints = new ArrayList<V1beta1EndpointBuilder>();
            for (V1beta1Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        } else {
            this.endpoints = null;
        }
        return (A)this;
    }

    @Override
    public A withEndpoints(V1beta1Endpoint ... endpoints) {
        if (this.endpoints != null) {
            this.endpoints.clear();
        }
        if (endpoints != null) {
            for (V1beta1Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEndpoints() {
        return this.endpoints != null && !this.endpoints.isEmpty();
    }

    @Override
    public V1beta1EndpointSliceFluent.EndpointsNested<A> addNewEndpoint() {
        return new EndpointsNestedImpl();
    }

    @Override
    public V1beta1EndpointSliceFluent.EndpointsNested<A> addNewEndpointLike(V1beta1Endpoint item) {
        return new EndpointsNestedImpl(-1, item);
    }

    @Override
    public V1beta1EndpointSliceFluent.EndpointsNested<A> setNewEndpointLike(int index, V1beta1Endpoint item) {
        return new EndpointsNestedImpl(index, item);
    }

    @Override
    public V1beta1EndpointSliceFluent.EndpointsNested<A> editEndpoint(int index) {
        if (this.endpoints.size() <= index) {
            throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public V1beta1EndpointSliceFluent.EndpointsNested<A> editFirstEndpoint() {
        if (this.endpoints.size() == 0) {
            throw new RuntimeException("Can't edit first endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(0, this.buildEndpoint(0));
    }

    @Override
    public V1beta1EndpointSliceFluent.EndpointsNested<A> editLastEndpoint() {
        int index = this.endpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public V1beta1EndpointSliceFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<V1beta1EndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (!predicate.apply(this.endpoints.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching endpoints. No match found.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1beta1EndpointSliceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1beta1EndpointSliceFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1beta1EndpointSliceFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1beta1EndpointSliceFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1beta1EndpointSliceFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToPorts(int index, V1beta1EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1beta1EndpointPortBuilder>();
        }
        V1beta1EndpointPortBuilder builder = new V1beta1EndpointPortBuilder(item);
        this._visitables.get("ports").add(index >= 0 ? index : this._visitables.get("ports").size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, V1beta1EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1beta1EndpointPortBuilder>();
        }
        V1beta1EndpointPortBuilder builder = new V1beta1EndpointPortBuilder(item);
        if (index < 0 || index >= this._visitables.get("ports").size()) {
            this._visitables.get("ports").add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(V1beta1EndpointPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1beta1EndpointPortBuilder>();
        }
        for (V1beta1EndpointPort item : items) {
            V1beta1EndpointPortBuilder builder = new V1beta1EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<V1beta1EndpointPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1beta1EndpointPortBuilder>();
        }
        for (V1beta1EndpointPort item : items) {
            V1beta1EndpointPortBuilder builder = new V1beta1EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(V1beta1EndpointPort ... items) {
        for (V1beta1EndpointPort item : items) {
            V1beta1EndpointPortBuilder builder = new V1beta1EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<V1beta1EndpointPort> items) {
        for (V1beta1EndpointPort item : items) {
            V1beta1EndpointPortBuilder builder = new V1beta1EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<V1beta1EndpointPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<V1beta1EndpointPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            V1beta1EndpointPortBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1beta1EndpointPort> getPorts() {
        return V1beta1EndpointSliceFluentImpl.build(this.ports);
    }

    @Override
    public List<V1beta1EndpointPort> buildPorts() {
        return V1beta1EndpointSliceFluentImpl.build(this.ports);
    }

    @Override
    public V1beta1EndpointPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public V1beta1EndpointPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public V1beta1EndpointPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public V1beta1EndpointPort buildMatchingPort(Predicate<V1beta1EndpointPortBuilder> predicate) {
        for (V1beta1EndpointPortBuilder item : this.ports) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<V1beta1EndpointPortBuilder> predicate) {
        for (V1beta1EndpointPortBuilder item : this.ports) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<V1beta1EndpointPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList<V1beta1EndpointPortBuilder>();
            for (V1beta1EndpointPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(V1beta1EndpointPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (V1beta1EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public V1beta1EndpointSliceFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public V1beta1EndpointSliceFluent.PortsNested<A> addNewPortLike(V1beta1EndpointPort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public V1beta1EndpointSliceFluent.PortsNested<A> setNewPortLike(int index, V1beta1EndpointPort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public V1beta1EndpointSliceFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public V1beta1EndpointSliceFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public V1beta1EndpointSliceFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public V1beta1EndpointSliceFluent.PortsNested<A> editMatchingPort(Predicate<V1beta1EndpointPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.apply(this.ports.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1EndpointSliceFluentImpl that = (V1beta1EndpointSliceFluentImpl)o;
        if (this.addressType != null ? !this.addressType.equals(that.addressType) : that.addressType != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.endpoints != null ? !this.endpoints.equals(that.endpoints) : that.endpoints != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }

    public int hashCode() {
        return Objects.hash(this.addressType, this.apiVersion, this.endpoints, this.kind, this.metadata, this.ports, super.hashCode());
    }

    public class PortsNestedImpl<N>
    extends V1beta1EndpointPortFluentImpl<V1beta1EndpointSliceFluent.PortsNested<N>>
    implements V1beta1EndpointSliceFluent.PortsNested<N>,
    Nested<N> {
        private final V1beta1EndpointPortBuilder builder;
        private final int index;

        PortsNestedImpl(int index, V1beta1EndpointPort item) {
            this.index = index;
            this.builder = new V1beta1EndpointPortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new V1beta1EndpointPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1EndpointSliceFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1beta1EndpointSliceFluent.MetadataNested<N>>
    implements V1beta1EndpointSliceFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1EndpointSliceFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class EndpointsNestedImpl<N>
    extends V1beta1EndpointFluentImpl<V1beta1EndpointSliceFluent.EndpointsNested<N>>
    implements V1beta1EndpointSliceFluent.EndpointsNested<N>,
    Nested<N> {
        private final V1beta1EndpointBuilder builder;
        private final int index;

        EndpointsNestedImpl(int index, V1beta1Endpoint item) {
            this.index = index;
            this.builder = new V1beta1EndpointBuilder(this, item);
        }

        EndpointsNestedImpl() {
            this.index = -1;
            this.builder = new V1beta1EndpointBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1EndpointSliceFluentImpl.this.setToEndpoints(this.index, this.builder.build());
        }

        @Override
        public N endEndpoint() {
            return this.and();
        }
    }
}

