/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1Condition;
import io.kubernetes.client.openapi.models.V1ConditionBuilder;
import io.kubernetes.client.openapi.models.V1ConditionFluentImpl;
import io.kubernetes.client.openapi.models.V1LoadBalancerStatus;
import io.kubernetes.client.openapi.models.V1LoadBalancerStatusBuilder;
import io.kubernetes.client.openapi.models.V1LoadBalancerStatusFluentImpl;
import io.kubernetes.client.openapi.models.V1ServiceStatus;
import io.kubernetes.client.openapi.models.V1ServiceStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class V1ServiceStatusFluentImpl<A extends V1ServiceStatusFluent<A>>
extends BaseFluent<A>
implements V1ServiceStatusFluent<A> {
    private List<V1ConditionBuilder> conditions;
    private V1LoadBalancerStatusBuilder loadBalancer;

    public V1ServiceStatusFluentImpl() {
    }

    public V1ServiceStatusFluentImpl(V1ServiceStatus instance) {
        this.withConditions(instance.getConditions());
        this.withLoadBalancer(instance.getLoadBalancer());
    }

    @Override
    public A addToConditions(int index, V1Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1ConditionBuilder>();
        }
        V1ConditionBuilder builder = new V1ConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, V1Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1ConditionBuilder>();
        }
        V1ConditionBuilder builder = new V1ConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1ConditionBuilder>();
        }
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1ConditionBuilder>();
        }
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1Condition ... items) {
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1Condition> items) {
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<V1ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1ConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1ConditionBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Condition> getConditions() {
        return V1ServiceStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<V1Condition> buildConditions() {
        return V1ServiceStatusFluentImpl.build(this.conditions);
    }

    @Override
    public V1Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1Condition buildMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        for (V1ConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        for (V1ConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<V1Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<V1ConditionBuilder>();
            for (V1Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (V1Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1ServiceStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1ServiceStatusFluent.ConditionsNested<A> addNewConditionLike(V1Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1ServiceStatusFluent.ConditionsNested<A> setNewConditionLike(int index, V1Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1ServiceStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1ServiceStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1ServiceStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1ServiceStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    @Deprecated
    public V1LoadBalancerStatus getLoadBalancer() {
        return this.loadBalancer != null ? this.loadBalancer.build() : null;
    }

    @Override
    public V1LoadBalancerStatus buildLoadBalancer() {
        return this.loadBalancer != null ? this.loadBalancer.build() : null;
    }

    @Override
    public A withLoadBalancer(V1LoadBalancerStatus loadBalancer) {
        this._visitables.get("loadBalancer").remove(this.loadBalancer);
        if (loadBalancer != null) {
            this.loadBalancer = new V1LoadBalancerStatusBuilder(loadBalancer);
            this._visitables.get("loadBalancer").add(this.loadBalancer);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    @Override
    public V1ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancer() {
        return new LoadBalancerNestedImpl();
    }

    @Override
    public V1ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancerLike(V1LoadBalancerStatus item) {
        return new LoadBalancerNestedImpl(item);
    }

    @Override
    public V1ServiceStatusFluent.LoadBalancerNested<A> editLoadBalancer() {
        return this.withNewLoadBalancerLike(this.getLoadBalancer());
    }

    @Override
    public V1ServiceStatusFluent.LoadBalancerNested<A> editOrNewLoadBalancer() {
        return this.withNewLoadBalancerLike(this.getLoadBalancer() != null ? this.getLoadBalancer() : new V1LoadBalancerStatusBuilder().build());
    }

    @Override
    public V1ServiceStatusFluent.LoadBalancerNested<A> editOrNewLoadBalancerLike(V1LoadBalancerStatus item) {
        return this.withNewLoadBalancerLike(this.getLoadBalancer() != null ? this.getLoadBalancer() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ServiceStatusFluentImpl that = (V1ServiceStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        return !(this.loadBalancer != null ? !this.loadBalancer.equals(that.loadBalancer) : that.loadBalancer != null);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.loadBalancer, super.hashCode());
    }

    public class LoadBalancerNestedImpl<N>
    extends V1LoadBalancerStatusFluentImpl<V1ServiceStatusFluent.LoadBalancerNested<N>>
    implements V1ServiceStatusFluent.LoadBalancerNested<N>,
    Nested<N> {
        private final V1LoadBalancerStatusBuilder builder;

        LoadBalancerNestedImpl(V1LoadBalancerStatus item) {
            this.builder = new V1LoadBalancerStatusBuilder(this, item);
        }

        LoadBalancerNestedImpl() {
            this.builder = new V1LoadBalancerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ServiceStatusFluentImpl.this.withLoadBalancer(this.builder.build());
        }

        @Override
        public N endLoadBalancer() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends V1ConditionFluentImpl<V1ServiceStatusFluent.ConditionsNested<N>>
    implements V1ServiceStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final V1ConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, V1Condition item) {
            this.index = index;
            this.builder = new V1ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1ConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ServiceStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

