/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import io.kubernetes.client.openapi.models.V1JobSpec;
import io.kubernetes.client.openapi.models.V1JobSpecFluent;
import io.kubernetes.client.openapi.models.V1JobSpecFluentImpl;
import java.util.Objects;

public class V1JobSpecBuilder
extends V1JobSpecFluentImpl<V1JobSpecBuilder>
implements VisitableBuilder<V1JobSpec, V1JobSpecBuilder> {
    V1JobSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1JobSpecBuilder() {
        this(true);
    }

    public V1JobSpecBuilder(Boolean validationEnabled) {
        this(new V1JobSpec(), validationEnabled);
    }

    public V1JobSpecBuilder(V1JobSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public V1JobSpecBuilder(V1JobSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new V1JobSpec(), validationEnabled);
    }

    public V1JobSpecBuilder(V1JobSpecFluent<?> fluent, V1JobSpec instance) {
        this(fluent, instance, true);
    }

    public V1JobSpecBuilder(V1JobSpecFluent<?> fluent, V1JobSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        fluent.withBackoffLimit(instance.getBackoffLimit());
        fluent.withCompletions(instance.getCompletions());
        fluent.withManualSelector(instance.getManualSelector());
        fluent.withParallelism(instance.getParallelism());
        fluent.withSelector(instance.getSelector());
        fluent.withTemplate(instance.getTemplate());
        fluent.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
        this.validationEnabled = validationEnabled;
    }

    public V1JobSpecBuilder(V1JobSpec instance) {
        this(instance, (Boolean)true);
    }

    public V1JobSpecBuilder(V1JobSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withBackoffLimit(instance.getBackoffLimit());
        this.withCompletions(instance.getCompletions());
        this.withManualSelector(instance.getManualSelector());
        this.withParallelism(instance.getParallelism());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
        this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public V1JobSpec build() {
        V1JobSpec buildable = new V1JobSpec();
        buildable.setActiveDeadlineSeconds(this.fluent.getActiveDeadlineSeconds());
        buildable.setBackoffLimit(this.fluent.getBackoffLimit());
        buildable.setCompletions(this.fluent.getCompletions());
        buildable.setManualSelector(this.fluent.isManualSelector());
        buildable.setParallelism(this.fluent.getParallelism());
        buildable.setSelector(this.fluent.getSelector());
        buildable.setTemplate(this.fluent.getTemplate());
        buildable.setTtlSecondsAfterFinished(this.fluent.getTtlSecondsAfterFinished());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1JobSpecBuilder that = (V1JobSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

