package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1HostPortRangeBuilder extends V1beta1HostPortRangeFluentImpl<V1beta1HostPortRangeBuilder> implements VisitableBuilder<V1beta1HostPortRange,V1beta1HostPortRangeBuilder> {

    V1beta1HostPortRangeFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1HostPortRangeBuilder() { 
        this(true);
    }


    public V1beta1HostPortRangeBuilder(Boolean validationEnabled) { 
        this(new V1beta1HostPortRange(), validationEnabled);
    }


    public V1beta1HostPortRangeBuilder(V1beta1HostPortRangeFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1beta1HostPortRangeBuilder(V1beta1HostPortRangeFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1beta1HostPortRange(), validationEnabled);
    }


    public V1beta1HostPortRangeBuilder(V1beta1HostPortRangeFluent<?> fluent,V1beta1HostPortRange instance) { 
        this(fluent, instance, true);
    }


    public V1beta1HostPortRangeBuilder(V1beta1HostPortRangeFluent<?> fluent,V1beta1HostPortRange instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withMax(instance.getMax());

        fluent.withMin(instance.getMin());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1HostPortRangeBuilder(V1beta1HostPortRange instance) { 
        this(instance,true);
    }


    public V1beta1HostPortRangeBuilder(V1beta1HostPortRange instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withMax(instance.getMax());

        this.withMin(instance.getMin());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1HostPortRange build() {
        V1beta1HostPortRange buildable = new V1beta1HostPortRange();
        buildable.setMax(fluent.getMax());
        buildable.setMin(fluent.getMin());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1beta1HostPortRangeBuilder that = (V1beta1HostPortRangeBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
