package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;

public interface V1beta1EndpointSliceFluent<A extends V1beta1EndpointSliceFluent<A>> extends Fluent<A> {


    public String getAddressType();
    public A withAddressType(String addressType);
    public Boolean hasAddressType();
    public A withNewAddressType(String arg1);
    public A withNewAddressType(StringBuilder arg1);
    public A withNewAddressType(StringBuffer arg1);
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToEndpoints(int index,V1beta1Endpoint item);
    public A setToEndpoints(int index,V1beta1Endpoint item);
    public A addToEndpoints(V1beta1Endpoint... items);
    public A addAllToEndpoints(Collection<V1beta1Endpoint> items);
    public A removeFromEndpoints(V1beta1Endpoint... items);
    public A removeAllFromEndpoints(Collection<V1beta1Endpoint> items);
    public A removeMatchingFromEndpoints(io.kubernetes.client.fluent.Predicate<V1beta1EndpointBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1Endpoint> getEndpoints();
    public List<V1beta1Endpoint> buildEndpoints();
    public V1beta1Endpoint buildEndpoint(int index);
    public V1beta1Endpoint buildFirstEndpoint();
    public V1beta1Endpoint buildLastEndpoint();
    public V1beta1Endpoint buildMatchingEndpoint(io.kubernetes.client.fluent.Predicate<V1beta1EndpointBuilder> predicate);
    public Boolean hasMatchingEndpoint(io.kubernetes.client.fluent.Predicate<V1beta1EndpointBuilder> predicate);
    public A withEndpoints(List<V1beta1Endpoint> endpoints);
    public A withEndpoints(V1beta1Endpoint... endpoints);
    public Boolean hasEndpoints();
    public V1beta1EndpointSliceFluent.EndpointsNested<A> addNewEndpoint();
    public V1beta1EndpointSliceFluent.EndpointsNested<A> addNewEndpointLike(V1beta1Endpoint item);
    public V1beta1EndpointSliceFluent.EndpointsNested<A> setNewEndpointLike(int index,V1beta1Endpoint item);
    public V1beta1EndpointSliceFluent.EndpointsNested<A> editEndpoint(int index);
    public V1beta1EndpointSliceFluent.EndpointsNested<A> editFirstEndpoint();
    public V1beta1EndpointSliceFluent.EndpointsNested<A> editLastEndpoint();
    public V1beta1EndpointSliceFluent.EndpointsNested<A> editMatchingEndpoint(io.kubernetes.client.fluent.Predicate<V1beta1EndpointBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public V1beta1EndpointSliceFluent.MetadataNested<A> withNewMetadata();
    public V1beta1EndpointSliceFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public V1beta1EndpointSliceFluent.MetadataNested<A> editMetadata();
    public V1beta1EndpointSliceFluent.MetadataNested<A> editOrNewMetadata();
    public V1beta1EndpointSliceFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);
    public A addToPorts(int index,V1beta1EndpointPort item);
    public A setToPorts(int index,V1beta1EndpointPort item);
    public A addToPorts(V1beta1EndpointPort... items);
    public A addAllToPorts(Collection<V1beta1EndpointPort> items);
    public A removeFromPorts(V1beta1EndpointPort... items);
    public A removeAllFromPorts(Collection<V1beta1EndpointPort> items);
    public A removeMatchingFromPorts(io.kubernetes.client.fluent.Predicate<V1beta1EndpointPortBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta1EndpointPort> getPorts();
    public List<V1beta1EndpointPort> buildPorts();
    public V1beta1EndpointPort buildPort(int index);
    public V1beta1EndpointPort buildFirstPort();
    public V1beta1EndpointPort buildLastPort();
    public V1beta1EndpointPort buildMatchingPort(io.kubernetes.client.fluent.Predicate<V1beta1EndpointPortBuilder> predicate);
    public Boolean hasMatchingPort(io.kubernetes.client.fluent.Predicate<V1beta1EndpointPortBuilder> predicate);
    public A withPorts(List<V1beta1EndpointPort> ports);
    public A withPorts(V1beta1EndpointPort... ports);
    public Boolean hasPorts();
    public V1beta1EndpointSliceFluent.PortsNested<A> addNewPort();
    public V1beta1EndpointSliceFluent.PortsNested<A> addNewPortLike(V1beta1EndpointPort item);
    public V1beta1EndpointSliceFluent.PortsNested<A> setNewPortLike(int index,V1beta1EndpointPort item);
    public V1beta1EndpointSliceFluent.PortsNested<A> editPort(int index);
    public V1beta1EndpointSliceFluent.PortsNested<A> editFirstPort();
    public V1beta1EndpointSliceFluent.PortsNested<A> editLastPort();
    public V1beta1EndpointSliceFluent.PortsNested<A> editMatchingPort(io.kubernetes.client.fluent.Predicate<V1beta1EndpointPortBuilder> predicate);
    public interface EndpointsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1beta1EndpointFluent<V1beta1EndpointSliceFluent.EndpointsNested<N>> {

        public N and();
        public N endEndpoint();    }


    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<V1beta1EndpointSliceFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface PortsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1beta1EndpointPortFluent<V1beta1EndpointSliceFluent.PortsNested<N>> {

        public N and();
        public N endPort();    }


}
