package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1EndpointBuilder extends V1beta1EndpointFluentImpl<V1beta1EndpointBuilder> implements VisitableBuilder<V1beta1Endpoint,V1beta1EndpointBuilder> {

    V1beta1EndpointFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1EndpointBuilder() { 
        this(true);
    }


    public V1beta1EndpointBuilder(Boolean validationEnabled) { 
        this(new V1beta1Endpoint(), validationEnabled);
    }


    public V1beta1EndpointBuilder(V1beta1EndpointFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1beta1EndpointBuilder(V1beta1EndpointFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1beta1Endpoint(), validationEnabled);
    }


    public V1beta1EndpointBuilder(V1beta1EndpointFluent<?> fluent,V1beta1Endpoint instance) { 
        this(fluent, instance, true);
    }


    public V1beta1EndpointBuilder(V1beta1EndpointFluent<?> fluent,V1beta1Endpoint instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAddresses(instance.getAddresses());

        fluent.withConditions(instance.getConditions());

        fluent.withHostname(instance.getHostname());

        fluent.withTargetRef(instance.getTargetRef());

        fluent.withTopology(instance.getTopology());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1EndpointBuilder(V1beta1Endpoint instance) { 
        this(instance,true);
    }


    public V1beta1EndpointBuilder(V1beta1Endpoint instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAddresses(instance.getAddresses());

        this.withConditions(instance.getConditions());

        this.withHostname(instance.getHostname());

        this.withTargetRef(instance.getTargetRef());

        this.withTopology(instance.getTopology());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1Endpoint build() {
        V1beta1Endpoint buildable = new V1beta1Endpoint();
        buildable.setAddresses(fluent.getAddresses());
        buildable.setConditions(fluent.getConditions());
        buildable.setHostname(fluent.getHostname());
        buildable.setTargetRef(fluent.getTargetRef());
        buildable.setTopology(fluent.getTopology());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1beta1EndpointBuilder that = (V1beta1EndpointBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
