package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1ScopeSelectorFluentImpl<A extends V1ScopeSelectorFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ScopeSelectorFluent<A> {

    private List<V1ScopedResourceSelectorRequirementBuilder> matchExpressions;

    public V1ScopeSelectorFluentImpl() { 
    }


    public V1ScopeSelectorFluentImpl(V1ScopeSelector instance) { 
        this.withMatchExpressions(instance.getMatchExpressions());

    }


    public A addToMatchExpressions(int index,V1ScopedResourceSelectorRequirement item) {
        if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1ScopedResourceSelectorRequirementBuilder>();}
        V1ScopedResourceSelectorRequirementBuilder builder = new V1ScopedResourceSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(index >= 0 ? index : _visitables.get("matchExpressions").size(), builder);this.matchExpressions.add(index >= 0 ? index : matchExpressions.size(), builder); return (A)this;
    }

    public A setToMatchExpressions(int index,V1ScopedResourceSelectorRequirement item) {
        if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1ScopedResourceSelectorRequirementBuilder>();}
        V1ScopedResourceSelectorRequirementBuilder builder = new V1ScopedResourceSelectorRequirementBuilder(item);
        if (index < 0 || index >= _visitables.get("matchExpressions").size()) { _visitables.get("matchExpressions").add(builder); } else { _visitables.get("matchExpressions").set(index, builder);}
        if (index < 0 || index >= matchExpressions.size()) { matchExpressions.add(builder); } else { matchExpressions.set(index, builder);}
         return (A)this;
    }

    public A addToMatchExpressions(V1ScopedResourceSelectorRequirement... items) {
        if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1ScopedResourceSelectorRequirementBuilder>();}
        for (V1ScopedResourceSelectorRequirement item : items) {V1ScopedResourceSelectorRequirementBuilder builder = new V1ScopedResourceSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(builder);this.matchExpressions.add(builder);} return (A)this;
    }

    public A addAllToMatchExpressions(Collection<V1ScopedResourceSelectorRequirement> items) {
        if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<V1ScopedResourceSelectorRequirementBuilder>();}
        for (V1ScopedResourceSelectorRequirement item : items) {V1ScopedResourceSelectorRequirementBuilder builder = new V1ScopedResourceSelectorRequirementBuilder(item);_visitables.get("matchExpressions").add(builder);this.matchExpressions.add(builder);} return (A)this;
    }

    public A removeFromMatchExpressions(V1ScopedResourceSelectorRequirement... items) {
        for (V1ScopedResourceSelectorRequirement item : items) {V1ScopedResourceSelectorRequirementBuilder builder = new V1ScopedResourceSelectorRequirementBuilder(item);_visitables.get("matchExpressions").remove(builder);if (this.matchExpressions != null) {this.matchExpressions.remove(builder);}} return (A)this;
    }

    public A removeAllFromMatchExpressions(Collection<V1ScopedResourceSelectorRequirement> items) {
        for (V1ScopedResourceSelectorRequirement item : items) {V1ScopedResourceSelectorRequirementBuilder builder = new V1ScopedResourceSelectorRequirementBuilder(item);_visitables.get("matchExpressions").remove(builder);if (this.matchExpressions != null) {this.matchExpressions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromMatchExpressions(io.kubernetes.client.fluent.Predicate<V1ScopedResourceSelectorRequirementBuilder> predicate) {
        if (matchExpressions == null) return (A) this;
        final Iterator<V1ScopedResourceSelectorRequirementBuilder> each = matchExpressions.iterator();
        final List visitables = _visitables.get("matchExpressions");
        while (each.hasNext()) {
          V1ScopedResourceSelectorRequirementBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMatchExpressions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ScopedResourceSelectorRequirement> getMatchExpressions() {
        return build(matchExpressions);
    }

    public List<V1ScopedResourceSelectorRequirement> buildMatchExpressions() {
        return build(matchExpressions);
    }

    public V1ScopedResourceSelectorRequirement buildMatchExpression(int index) {
        return this.matchExpressions.get(index).build();
    }

    public V1ScopedResourceSelectorRequirement buildFirstMatchExpression() {
        return this.matchExpressions.get(0).build();
    }

    public V1ScopedResourceSelectorRequirement buildLastMatchExpression() {
        return this.matchExpressions.get(matchExpressions.size() - 1).build();
    }

    public V1ScopedResourceSelectorRequirement buildMatchingMatchExpression(io.kubernetes.client.fluent.Predicate<V1ScopedResourceSelectorRequirementBuilder> predicate) {
        for (V1ScopedResourceSelectorRequirementBuilder item: matchExpressions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingMatchExpression(io.kubernetes.client.fluent.Predicate<V1ScopedResourceSelectorRequirementBuilder> predicate) {
        for (V1ScopedResourceSelectorRequirementBuilder item: matchExpressions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withMatchExpressions(List<V1ScopedResourceSelectorRequirement> matchExpressions) {
        if (this.matchExpressions != null) { _visitables.get("matchExpressions").removeAll(this.matchExpressions);}
        if (matchExpressions != null) {this.matchExpressions = new ArrayList<V1ScopedResourceSelectorRequirementBuilder>(); for (V1ScopedResourceSelectorRequirement item : matchExpressions){this.addToMatchExpressions(item);}} else { this.matchExpressions = null;} return (A) this;
    }

    public A withMatchExpressions(V1ScopedResourceSelectorRequirement... matchExpressions) {
        if (this.matchExpressions != null) {this.matchExpressions.clear();}
        if (matchExpressions != null) {for (V1ScopedResourceSelectorRequirement item :matchExpressions){ this.addToMatchExpressions(item);}} return (A) this;
    }

    public Boolean hasMatchExpressions() {
        return matchExpressions != null && !matchExpressions.isEmpty();
    }

    public V1ScopeSelectorFluent.MatchExpressionsNested<A> addNewMatchExpression() {
        return new MatchExpressionsNestedImpl();
    }

    public V1ScopeSelectorFluent.MatchExpressionsNested<A> addNewMatchExpressionLike(V1ScopedResourceSelectorRequirement item) {
        return new MatchExpressionsNestedImpl(-1, item);
    }

    public V1ScopeSelectorFluent.MatchExpressionsNested<A> setNewMatchExpressionLike(int index,V1ScopedResourceSelectorRequirement item) {
        return new MatchExpressionsNestedImpl(index, item);
    }

    public V1ScopeSelectorFluent.MatchExpressionsNested<A> editMatchExpression(int index) {
        if (matchExpressions.size() <= index) throw new RuntimeException("Can't edit matchExpressions. Index exceeds size.");
        return setNewMatchExpressionLike(index, buildMatchExpression(index));
    }

    public V1ScopeSelectorFluent.MatchExpressionsNested<A> editFirstMatchExpression() {
        if (matchExpressions.size() == 0) throw new RuntimeException("Can't edit first matchExpressions. The list is empty.");
        return setNewMatchExpressionLike(0, buildMatchExpression(0));
    }

    public V1ScopeSelectorFluent.MatchExpressionsNested<A> editLastMatchExpression() {
        int index = matchExpressions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last matchExpressions. The list is empty.");
        return setNewMatchExpressionLike(index, buildMatchExpression(index));
    }

    public V1ScopeSelectorFluent.MatchExpressionsNested<A> editMatchingMatchExpression(io.kubernetes.client.fluent.Predicate<V1ScopedResourceSelectorRequirementBuilder> predicate) {
        int index = -1;
        for (int i=0;i<matchExpressions.size();i++) { 
        if (predicate.apply(matchExpressions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching matchExpressions. No match found.");
        return setNewMatchExpressionLike(index, buildMatchExpression(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1ScopeSelectorFluentImpl that = (V1ScopeSelectorFluentImpl) o;
        if (matchExpressions != null ? !matchExpressions.equals(that.matchExpressions) :that.matchExpressions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(matchExpressions,  super.hashCode());
    }

    public class MatchExpressionsNestedImpl<N> extends V1ScopedResourceSelectorRequirementFluentImpl<V1ScopeSelectorFluent.MatchExpressionsNested<N>> implements V1ScopeSelectorFluent.MatchExpressionsNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1ScopedResourceSelectorRequirementBuilder builder;
        private final int index;

        MatchExpressionsNestedImpl(int index,V1ScopedResourceSelectorRequirement item) {
            this.index = index;
            this.builder = new V1ScopedResourceSelectorRequirementBuilder(this, item);
        }

        MatchExpressionsNestedImpl() {
            this.index = -1;
            this.builder = new V1ScopedResourceSelectorRequirementBuilder(this);
        }

        public N and() {
             return (N) V1ScopeSelectorFluentImpl.this.setToMatchExpressions(index,builder.build());
        }

        public N endMatchExpression() {
             return and();
        }
    }


}
