package io.kubernetes.client.openapi.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1GlusterfsPersistentVolumeSourceFluentImpl<A extends V1GlusterfsPersistentVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1GlusterfsPersistentVolumeSourceFluent<A> {

    private String endpoints;
    private String endpointsNamespace;
    private String path;
    private Boolean readOnly;

    public V1GlusterfsPersistentVolumeSourceFluentImpl() { 
    }


    public V1GlusterfsPersistentVolumeSourceFluentImpl(V1GlusterfsPersistentVolumeSource instance) { 
        this.withEndpoints(instance.getEndpoints());

        this.withEndpointsNamespace(instance.getEndpointsNamespace());

        this.withPath(instance.getPath());

        this.withReadOnly(instance.getReadOnly());

    }


    public String getEndpoints() {
        return this.endpoints;
    }

    public A withEndpoints(String endpoints) {
        this.endpoints=endpoints; return (A) this;
    }

    public Boolean hasEndpoints() {
        return this.endpoints != null;
    }

    public A withNewEndpoints(String arg1) {
        return (A)withEndpoints(new String(arg1));
    }

    public A withNewEndpoints(StringBuilder arg1) {
        return (A)withEndpoints(new String(arg1));
    }

    public A withNewEndpoints(StringBuffer arg1) {
        return (A)withEndpoints(new String(arg1));
    }

    public String getEndpointsNamespace() {
        return this.endpointsNamespace;
    }

    public A withEndpointsNamespace(String endpointsNamespace) {
        this.endpointsNamespace=endpointsNamespace; return (A) this;
    }

    public Boolean hasEndpointsNamespace() {
        return this.endpointsNamespace != null;
    }

    public A withNewEndpointsNamespace(String arg1) {
        return (A)withEndpointsNamespace(new String(arg1));
    }

    public A withNewEndpointsNamespace(StringBuilder arg1) {
        return (A)withEndpointsNamespace(new String(arg1));
    }

    public A withNewEndpointsNamespace(StringBuffer arg1) {
        return (A)withEndpointsNamespace(new String(arg1));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path=path; return (A) this;
    }

    public Boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(String arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1) {
        return (A)withPath(new String(arg1));
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1) {
        return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1) {
        return (A)withReadOnly(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1GlusterfsPersistentVolumeSourceFluentImpl that = (V1GlusterfsPersistentVolumeSourceFluentImpl) o;
        if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
        if (endpointsNamespace != null ? !endpointsNamespace.equals(that.endpointsNamespace) :that.endpointsNamespace != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(endpoints,  endpointsNamespace,  path,  readOnly,  super.hashCode());
    }

}
