package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1EmptyDirVolumeSourceBuilder extends V1EmptyDirVolumeSourceFluentImpl<V1EmptyDirVolumeSourceBuilder> implements VisitableBuilder<V1EmptyDirVolumeSource,V1EmptyDirVolumeSourceBuilder> {

    V1EmptyDirVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1EmptyDirVolumeSourceBuilder() { 
        this(true);
    }


    public V1EmptyDirVolumeSourceBuilder(Boolean validationEnabled) { 
        this(new V1EmptyDirVolumeSource(), validationEnabled);
    }


    public V1EmptyDirVolumeSourceBuilder(V1EmptyDirVolumeSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1EmptyDirVolumeSourceBuilder(V1EmptyDirVolumeSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1EmptyDirVolumeSource(), validationEnabled);
    }


    public V1EmptyDirVolumeSourceBuilder(V1EmptyDirVolumeSourceFluent<?> fluent,V1EmptyDirVolumeSource instance) { 
        this(fluent, instance, true);
    }


    public V1EmptyDirVolumeSourceBuilder(V1EmptyDirVolumeSourceFluent<?> fluent,V1EmptyDirVolumeSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withMedium(instance.getMedium());

        fluent.withSizeLimit(instance.getSizeLimit());

        this.validationEnabled = validationEnabled; 
    }


    public V1EmptyDirVolumeSourceBuilder(V1EmptyDirVolumeSource instance) { 
        this(instance,true);
    }


    public V1EmptyDirVolumeSourceBuilder(V1EmptyDirVolumeSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withMedium(instance.getMedium());

        this.withSizeLimit(instance.getSizeLimit());

        this.validationEnabled = validationEnabled; 
    }


    public V1EmptyDirVolumeSource build() {
        V1EmptyDirVolumeSource buildable = new V1EmptyDirVolumeSource();
        buildable.setMedium(fluent.getMedium());
        buildable.setSizeLimit(fluent.getSizeLimit());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1EmptyDirVolumeSourceBuilder that = (V1EmptyDirVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
