package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1CustomResourceDefinitionSpecFluentImpl<A extends V1CustomResourceDefinitionSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1CustomResourceDefinitionSpecFluent<A> {

    private V1CustomResourceConversionBuilder conversion;
    private String group;
    private V1CustomResourceDefinitionNamesBuilder names;
    private Boolean preserveUnknownFields;
    private String scope;
    private List<V1CustomResourceDefinitionVersionBuilder> versions;

    public V1CustomResourceDefinitionSpecFluentImpl() { 
    }


    public V1CustomResourceDefinitionSpecFluentImpl(V1CustomResourceDefinitionSpec instance) { 
        this.withConversion(instance.getConversion());

        this.withGroup(instance.getGroup());

        this.withNames(instance.getNames());

        this.withPreserveUnknownFields(instance.getPreserveUnknownFields());

        this.withScope(instance.getScope());

        this.withVersions(instance.getVersions());

    }


    
/**
 * This method has been deprecated, please use method buildConversion instead.
 * @return The buildable object.
 */
@Deprecated public V1CustomResourceConversion getConversion() {
        return this.conversion!=null?this.conversion.build():null;
    }

    public V1CustomResourceConversion buildConversion() {
        return this.conversion!=null?this.conversion.build():null;
    }

    public A withConversion(V1CustomResourceConversion conversion) {
        _visitables.get("conversion").remove(this.conversion);
        if (conversion!=null){ this.conversion= new V1CustomResourceConversionBuilder(conversion); _visitables.get("conversion").add(this.conversion);} return (A) this;
    }

    public Boolean hasConversion() {
        return this.conversion != null;
    }

    public V1CustomResourceDefinitionSpecFluent.ConversionNested<A> withNewConversion() {
        return new ConversionNestedImpl();
    }

    public V1CustomResourceDefinitionSpecFluent.ConversionNested<A> withNewConversionLike(V1CustomResourceConversion item) {
        return new ConversionNestedImpl(item);
    }

    public V1CustomResourceDefinitionSpecFluent.ConversionNested<A> editConversion() {
        return withNewConversionLike(getConversion());
    }

    public V1CustomResourceDefinitionSpecFluent.ConversionNested<A> editOrNewConversion() {
        return withNewConversionLike(getConversion() != null ? getConversion(): new V1CustomResourceConversionBuilder().build());
    }

    public V1CustomResourceDefinitionSpecFluent.ConversionNested<A> editOrNewConversionLike(V1CustomResourceConversion item) {
        return withNewConversionLike(getConversion() != null ? getConversion(): item);
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group=group; return (A) this;
    }

    public Boolean hasGroup() {
        return this.group != null;
    }

    public A withNewGroup(String arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuilder arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuffer arg1) {
        return (A)withGroup(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildNames instead.
 * @return The buildable object.
 */
@Deprecated public V1CustomResourceDefinitionNames getNames() {
        return this.names!=null?this.names.build():null;
    }

    public V1CustomResourceDefinitionNames buildNames() {
        return this.names!=null?this.names.build():null;
    }

    public A withNames(V1CustomResourceDefinitionNames names) {
        _visitables.get("names").remove(this.names);
        if (names!=null){ this.names= new V1CustomResourceDefinitionNamesBuilder(names); _visitables.get("names").add(this.names);} return (A) this;
    }

    public Boolean hasNames() {
        return this.names != null;
    }

    public V1CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNames() {
        return new NamesNestedImpl();
    }

    public V1CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNamesLike(V1CustomResourceDefinitionNames item) {
        return new NamesNestedImpl(item);
    }

    public V1CustomResourceDefinitionSpecFluent.NamesNested<A> editNames() {
        return withNewNamesLike(getNames());
    }

    public V1CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNames() {
        return withNewNamesLike(getNames() != null ? getNames(): new V1CustomResourceDefinitionNamesBuilder().build());
    }

    public V1CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNamesLike(V1CustomResourceDefinitionNames item) {
        return withNewNamesLike(getNames() != null ? getNames(): item);
    }

    public Boolean isPreserveUnknownFields() {
        return this.preserveUnknownFields;
    }

    public A withPreserveUnknownFields(Boolean preserveUnknownFields) {
        this.preserveUnknownFields=preserveUnknownFields; return (A) this;
    }

    public Boolean hasPreserveUnknownFields() {
        return this.preserveUnknownFields != null;
    }

    public A withNewPreserveUnknownFields(String arg1) {
        return (A)withPreserveUnknownFields(new Boolean(arg1));
    }

    public A withNewPreserveUnknownFields(boolean arg1) {
        return (A)withPreserveUnknownFields(new Boolean(arg1));
    }

    public String getScope() {
        return this.scope;
    }

    public A withScope(String scope) {
        this.scope=scope; return (A) this;
    }

    public Boolean hasScope() {
        return this.scope != null;
    }

    public A withNewScope(String arg1) {
        return (A)withScope(new String(arg1));
    }

    public A withNewScope(StringBuilder arg1) {
        return (A)withScope(new String(arg1));
    }

    public A withNewScope(StringBuffer arg1) {
        return (A)withScope(new String(arg1));
    }

    public A addToVersions(int index,V1CustomResourceDefinitionVersion item) {
        if (this.versions == null) {this.versions = new ArrayList<V1CustomResourceDefinitionVersionBuilder>();}
        V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(index >= 0 ? index : _visitables.get("versions").size(), builder);this.versions.add(index >= 0 ? index : versions.size(), builder); return (A)this;
    }

    public A setToVersions(int index,V1CustomResourceDefinitionVersion item) {
        if (this.versions == null) {this.versions = new ArrayList<V1CustomResourceDefinitionVersionBuilder>();}
        V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);
        if (index < 0 || index >= _visitables.get("versions").size()) { _visitables.get("versions").add(builder); } else { _visitables.get("versions").set(index, builder);}
        if (index < 0 || index >= versions.size()) { versions.add(builder); } else { versions.set(index, builder);}
         return (A)this;
    }

    public A addToVersions(V1CustomResourceDefinitionVersion... items) {
        if (this.versions == null) {this.versions = new ArrayList<V1CustomResourceDefinitionVersionBuilder>();}
        for (V1CustomResourceDefinitionVersion item : items) {V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
    }

    public A addAllToVersions(Collection<V1CustomResourceDefinitionVersion> items) {
        if (this.versions == null) {this.versions = new ArrayList<V1CustomResourceDefinitionVersionBuilder>();}
        for (V1CustomResourceDefinitionVersion item : items) {V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
    }

    public A removeFromVersions(V1CustomResourceDefinitionVersion... items) {
        for (V1CustomResourceDefinitionVersion item : items) {V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
    }

    public A removeAllFromVersions(Collection<V1CustomResourceDefinitionVersion> items) {
        for (V1CustomResourceDefinitionVersion item : items) {V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVersions(io.kubernetes.client.fluent.Predicate<V1CustomResourceDefinitionVersionBuilder> predicate) {
        if (versions == null) return (A) this;
        final Iterator<V1CustomResourceDefinitionVersionBuilder> each = versions.iterator();
        final List visitables = _visitables.get("versions");
        while (each.hasNext()) {
          V1CustomResourceDefinitionVersionBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVersions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1CustomResourceDefinitionVersion> getVersions() {
        return build(versions);
    }

    public List<V1CustomResourceDefinitionVersion> buildVersions() {
        return build(versions);
    }

    public V1CustomResourceDefinitionVersion buildVersion(int index) {
        return this.versions.get(index).build();
    }

    public V1CustomResourceDefinitionVersion buildFirstVersion() {
        return this.versions.get(0).build();
    }

    public V1CustomResourceDefinitionVersion buildLastVersion() {
        return this.versions.get(versions.size() - 1).build();
    }

    public V1CustomResourceDefinitionVersion buildMatchingVersion(io.kubernetes.client.fluent.Predicate<V1CustomResourceDefinitionVersionBuilder> predicate) {
        for (V1CustomResourceDefinitionVersionBuilder item: versions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVersion(io.kubernetes.client.fluent.Predicate<V1CustomResourceDefinitionVersionBuilder> predicate) {
        for (V1CustomResourceDefinitionVersionBuilder item: versions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVersions(List<V1CustomResourceDefinitionVersion> versions) {
        if (this.versions != null) { _visitables.get("versions").removeAll(this.versions);}
        if (versions != null) {this.versions = new ArrayList<V1CustomResourceDefinitionVersionBuilder>(); for (V1CustomResourceDefinitionVersion item : versions){this.addToVersions(item);}} else { this.versions = null;} return (A) this;
    }

    public A withVersions(V1CustomResourceDefinitionVersion... versions) {
        if (this.versions != null) {this.versions.clear();}
        if (versions != null) {for (V1CustomResourceDefinitionVersion item :versions){ this.addToVersions(item);}} return (A) this;
    }

    public Boolean hasVersions() {
        return versions != null && !versions.isEmpty();
    }

    public V1CustomResourceDefinitionSpecFluent.VersionsNested<A> addNewVersion() {
        return new VersionsNestedImpl();
    }

    public V1CustomResourceDefinitionSpecFluent.VersionsNested<A> addNewVersionLike(V1CustomResourceDefinitionVersion item) {
        return new VersionsNestedImpl(-1, item);
    }

    public V1CustomResourceDefinitionSpecFluent.VersionsNested<A> setNewVersionLike(int index,V1CustomResourceDefinitionVersion item) {
        return new VersionsNestedImpl(index, item);
    }

    public V1CustomResourceDefinitionSpecFluent.VersionsNested<A> editVersion(int index) {
        if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
        return setNewVersionLike(index, buildVersion(index));
    }

    public V1CustomResourceDefinitionSpecFluent.VersionsNested<A> editFirstVersion() {
        if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
        return setNewVersionLike(0, buildVersion(0));
    }

    public V1CustomResourceDefinitionSpecFluent.VersionsNested<A> editLastVersion() {
        int index = versions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
        return setNewVersionLike(index, buildVersion(index));
    }

    public V1CustomResourceDefinitionSpecFluent.VersionsNested<A> editMatchingVersion(io.kubernetes.client.fluent.Predicate<V1CustomResourceDefinitionVersionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<versions.size();i++) { 
        if (predicate.apply(versions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
        return setNewVersionLike(index, buildVersion(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1CustomResourceDefinitionSpecFluentImpl that = (V1CustomResourceDefinitionSpecFluentImpl) o;
        if (conversion != null ? !conversion.equals(that.conversion) :that.conversion != null) return false;
        if (group != null ? !group.equals(that.group) :that.group != null) return false;
        if (names != null ? !names.equals(that.names) :that.names != null) return false;
        if (preserveUnknownFields != null ? !preserveUnknownFields.equals(that.preserveUnknownFields) :that.preserveUnknownFields != null) return false;
        if (scope != null ? !scope.equals(that.scope) :that.scope != null) return false;
        if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conversion,  group,  names,  preserveUnknownFields,  scope,  versions,  super.hashCode());
    }

    public class ConversionNestedImpl<N> extends V1CustomResourceConversionFluentImpl<V1CustomResourceDefinitionSpecFluent.ConversionNested<N>> implements V1CustomResourceDefinitionSpecFluent.ConversionNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1CustomResourceConversionBuilder builder;

        ConversionNestedImpl(V1CustomResourceConversion item) {
            this.builder = new V1CustomResourceConversionBuilder(this, item);
        }

        ConversionNestedImpl() {
            this.builder = new V1CustomResourceConversionBuilder(this);
        }

        public N and() {
             return (N) V1CustomResourceDefinitionSpecFluentImpl.this.withConversion(builder.build());
        }

        public N endConversion() {
             return and();
        }
    }


    public class NamesNestedImpl<N> extends V1CustomResourceDefinitionNamesFluentImpl<V1CustomResourceDefinitionSpecFluent.NamesNested<N>> implements V1CustomResourceDefinitionSpecFluent.NamesNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1CustomResourceDefinitionNamesBuilder builder;

        NamesNestedImpl(V1CustomResourceDefinitionNames item) {
            this.builder = new V1CustomResourceDefinitionNamesBuilder(this, item);
        }

        NamesNestedImpl() {
            this.builder = new V1CustomResourceDefinitionNamesBuilder(this);
        }

        public N and() {
             return (N) V1CustomResourceDefinitionSpecFluentImpl.this.withNames(builder.build());
        }

        public N endNames() {
             return and();
        }
    }


    public class VersionsNestedImpl<N> extends V1CustomResourceDefinitionVersionFluentImpl<V1CustomResourceDefinitionSpecFluent.VersionsNested<N>> implements V1CustomResourceDefinitionSpecFluent.VersionsNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1CustomResourceDefinitionVersionBuilder builder;
        private final int index;

        VersionsNestedImpl(int index,V1CustomResourceDefinitionVersion item) {
            this.index = index;
            this.builder = new V1CustomResourceDefinitionVersionBuilder(this, item);
        }

        VersionsNestedImpl() {
            this.index = -1;
            this.builder = new V1CustomResourceDefinitionVersionBuilder(this);
        }

        public N and() {
             return (N) V1CustomResourceDefinitionSpecFluentImpl.this.setToVersions(index,builder.build());
        }

        public N endVersion() {
             return and();
        }
    }


}
