package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1CSIVolumeSourceBuilder extends V1CSIVolumeSourceFluentImpl<V1CSIVolumeSourceBuilder> implements VisitableBuilder<V1CSIVolumeSource,V1CSIVolumeSourceBuilder> {

    V1CSIVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1CSIVolumeSourceBuilder() { 
        this(true);
    }


    public V1CSIVolumeSourceBuilder(Boolean validationEnabled) { 
        this(new V1CSIVolumeSource(), validationEnabled);
    }


    public V1CSIVolumeSourceBuilder(V1CSIVolumeSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1CSIVolumeSourceBuilder(V1CSIVolumeSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1CSIVolumeSource(), validationEnabled);
    }


    public V1CSIVolumeSourceBuilder(V1CSIVolumeSourceFluent<?> fluent,V1CSIVolumeSource instance) { 
        this(fluent, instance, true);
    }


    public V1CSIVolumeSourceBuilder(V1CSIVolumeSourceFluent<?> fluent,V1CSIVolumeSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withDriver(instance.getDriver());

        fluent.withFsType(instance.getFsType());

        fluent.withNodePublishSecretRef(instance.getNodePublishSecretRef());

        fluent.withReadOnly(instance.getReadOnly());

        fluent.withVolumeAttributes(instance.getVolumeAttributes());

        this.validationEnabled = validationEnabled; 
    }


    public V1CSIVolumeSourceBuilder(V1CSIVolumeSource instance) { 
        this(instance,true);
    }


    public V1CSIVolumeSourceBuilder(V1CSIVolumeSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withDriver(instance.getDriver());

        this.withFsType(instance.getFsType());

        this.withNodePublishSecretRef(instance.getNodePublishSecretRef());

        this.withReadOnly(instance.getReadOnly());

        this.withVolumeAttributes(instance.getVolumeAttributes());

        this.validationEnabled = validationEnabled; 
    }


    public V1CSIVolumeSource build() {
        V1CSIVolumeSource buildable = new V1CSIVolumeSource();
        buildable.setDriver(fluent.getDriver());
        buildable.setFsType(fluent.getFsType());
        buildable.setNodePublishSecretRef(fluent.getNodePublishSecretRef());
        buildable.setReadOnly(fluent.isReadOnly());
        buildable.setVolumeAttributes(fluent.getVolumeAttributes());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1CSIVolumeSourceBuilder that = (V1CSIVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
