package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1AffinityFluentImpl<A extends V1AffinityFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1AffinityFluent<A> {

    private V1NodeAffinityBuilder nodeAffinity;
    private V1PodAffinityBuilder podAffinity;
    private V1PodAntiAffinityBuilder podAntiAffinity;

    public V1AffinityFluentImpl() { 
    }


    public V1AffinityFluentImpl(V1Affinity instance) { 
        this.withNodeAffinity(instance.getNodeAffinity());

        this.withPodAffinity(instance.getPodAffinity());

        this.withPodAntiAffinity(instance.getPodAntiAffinity());

    }


    
/**
 * This method has been deprecated, please use method buildNodeAffinity instead.
 * @return The buildable object.
 */
@Deprecated public V1NodeAffinity getNodeAffinity() {
        return this.nodeAffinity!=null?this.nodeAffinity.build():null;
    }

    public V1NodeAffinity buildNodeAffinity() {
        return this.nodeAffinity!=null?this.nodeAffinity.build():null;
    }

    public A withNodeAffinity(V1NodeAffinity nodeAffinity) {
        _visitables.get("nodeAffinity").remove(this.nodeAffinity);
        if (nodeAffinity!=null){ this.nodeAffinity= new V1NodeAffinityBuilder(nodeAffinity); _visitables.get("nodeAffinity").add(this.nodeAffinity);} return (A) this;
    }

    public Boolean hasNodeAffinity() {
        return this.nodeAffinity != null;
    }

    public V1AffinityFluent.NodeAffinityNested<A> withNewNodeAffinity() {
        return new NodeAffinityNestedImpl();
    }

    public V1AffinityFluent.NodeAffinityNested<A> withNewNodeAffinityLike(V1NodeAffinity item) {
        return new NodeAffinityNestedImpl(item);
    }

    public V1AffinityFluent.NodeAffinityNested<A> editNodeAffinity() {
        return withNewNodeAffinityLike(getNodeAffinity());
    }

    public V1AffinityFluent.NodeAffinityNested<A> editOrNewNodeAffinity() {
        return withNewNodeAffinityLike(getNodeAffinity() != null ? getNodeAffinity(): new V1NodeAffinityBuilder().build());
    }

    public V1AffinityFluent.NodeAffinityNested<A> editOrNewNodeAffinityLike(V1NodeAffinity item) {
        return withNewNodeAffinityLike(getNodeAffinity() != null ? getNodeAffinity(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodAffinity instead.
 * @return The buildable object.
 */
@Deprecated public V1PodAffinity getPodAffinity() {
        return this.podAffinity!=null?this.podAffinity.build():null;
    }

    public V1PodAffinity buildPodAffinity() {
        return this.podAffinity!=null?this.podAffinity.build():null;
    }

    public A withPodAffinity(V1PodAffinity podAffinity) {
        _visitables.get("podAffinity").remove(this.podAffinity);
        if (podAffinity!=null){ this.podAffinity= new V1PodAffinityBuilder(podAffinity); _visitables.get("podAffinity").add(this.podAffinity);} return (A) this;
    }

    public Boolean hasPodAffinity() {
        return this.podAffinity != null;
    }

    public V1AffinityFluent.PodAffinityNested<A> withNewPodAffinity() {
        return new PodAffinityNestedImpl();
    }

    public V1AffinityFluent.PodAffinityNested<A> withNewPodAffinityLike(V1PodAffinity item) {
        return new PodAffinityNestedImpl(item);
    }

    public V1AffinityFluent.PodAffinityNested<A> editPodAffinity() {
        return withNewPodAffinityLike(getPodAffinity());
    }

    public V1AffinityFluent.PodAffinityNested<A> editOrNewPodAffinity() {
        return withNewPodAffinityLike(getPodAffinity() != null ? getPodAffinity(): new V1PodAffinityBuilder().build());
    }

    public V1AffinityFluent.PodAffinityNested<A> editOrNewPodAffinityLike(V1PodAffinity item) {
        return withNewPodAffinityLike(getPodAffinity() != null ? getPodAffinity(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodAntiAffinity instead.
 * @return The buildable object.
 */
@Deprecated public V1PodAntiAffinity getPodAntiAffinity() {
        return this.podAntiAffinity!=null?this.podAntiAffinity.build():null;
    }

    public V1PodAntiAffinity buildPodAntiAffinity() {
        return this.podAntiAffinity!=null?this.podAntiAffinity.build():null;
    }

    public A withPodAntiAffinity(V1PodAntiAffinity podAntiAffinity) {
        _visitables.get("podAntiAffinity").remove(this.podAntiAffinity);
        if (podAntiAffinity!=null){ this.podAntiAffinity= new V1PodAntiAffinityBuilder(podAntiAffinity); _visitables.get("podAntiAffinity").add(this.podAntiAffinity);} return (A) this;
    }

    public Boolean hasPodAntiAffinity() {
        return this.podAntiAffinity != null;
    }

    public V1AffinityFluent.PodAntiAffinityNested<A> withNewPodAntiAffinity() {
        return new PodAntiAffinityNestedImpl();
    }

    public V1AffinityFluent.PodAntiAffinityNested<A> withNewPodAntiAffinityLike(V1PodAntiAffinity item) {
        return new PodAntiAffinityNestedImpl(item);
    }

    public V1AffinityFluent.PodAntiAffinityNested<A> editPodAntiAffinity() {
        return withNewPodAntiAffinityLike(getPodAntiAffinity());
    }

    public V1AffinityFluent.PodAntiAffinityNested<A> editOrNewPodAntiAffinity() {
        return withNewPodAntiAffinityLike(getPodAntiAffinity() != null ? getPodAntiAffinity(): new V1PodAntiAffinityBuilder().build());
    }

    public V1AffinityFluent.PodAntiAffinityNested<A> editOrNewPodAntiAffinityLike(V1PodAntiAffinity item) {
        return withNewPodAntiAffinityLike(getPodAntiAffinity() != null ? getPodAntiAffinity(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1AffinityFluentImpl that = (V1AffinityFluentImpl) o;
        if (nodeAffinity != null ? !nodeAffinity.equals(that.nodeAffinity) :that.nodeAffinity != null) return false;
        if (podAffinity != null ? !podAffinity.equals(that.podAffinity) :that.podAffinity != null) return false;
        if (podAntiAffinity != null ? !podAntiAffinity.equals(that.podAntiAffinity) :that.podAntiAffinity != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(nodeAffinity,  podAffinity,  podAntiAffinity,  super.hashCode());
    }

    public class NodeAffinityNestedImpl<N> extends V1NodeAffinityFluentImpl<V1AffinityFluent.NodeAffinityNested<N>> implements V1AffinityFluent.NodeAffinityNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1NodeAffinityBuilder builder;

        NodeAffinityNestedImpl(V1NodeAffinity item) {
            this.builder = new V1NodeAffinityBuilder(this, item);
        }

        NodeAffinityNestedImpl() {
            this.builder = new V1NodeAffinityBuilder(this);
        }

        public N and() {
             return (N) V1AffinityFluentImpl.this.withNodeAffinity(builder.build());
        }

        public N endNodeAffinity() {
             return and();
        }
    }


    public class PodAffinityNestedImpl<N> extends V1PodAffinityFluentImpl<V1AffinityFluent.PodAffinityNested<N>> implements V1AffinityFluent.PodAffinityNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1PodAffinityBuilder builder;

        PodAffinityNestedImpl(V1PodAffinity item) {
            this.builder = new V1PodAffinityBuilder(this, item);
        }

        PodAffinityNestedImpl() {
            this.builder = new V1PodAffinityBuilder(this);
        }

        public N and() {
             return (N) V1AffinityFluentImpl.this.withPodAffinity(builder.build());
        }

        public N endPodAffinity() {
             return and();
        }
    }


    public class PodAntiAffinityNestedImpl<N> extends V1PodAntiAffinityFluentImpl<V1AffinityFluent.PodAntiAffinityNested<N>> implements V1AffinityFluent.PodAntiAffinityNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1PodAntiAffinityBuilder builder;

        PodAntiAffinityNestedImpl(V1PodAntiAffinity item) {
            this.builder = new V1PodAntiAffinityBuilder(this, item);
        }

        PodAntiAffinityNestedImpl() {
            this.builder = new V1PodAntiAffinityBuilder(this);
        }

        public N and() {
             return (N) V1AffinityFluentImpl.this.withPodAntiAffinity(builder.build());
        }

        public N endPodAntiAffinity() {
             return and();
        }
    }


}
