/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1PodSecurityContext;
import io.kubernetes.client.openapi.models.V1PodSecurityContextFluent;
import io.kubernetes.client.openapi.models.V1SELinuxOptions;
import io.kubernetes.client.openapi.models.V1SELinuxOptionsBuilder;
import io.kubernetes.client.openapi.models.V1SELinuxOptionsFluentImpl;
import io.kubernetes.client.openapi.models.V1SeccompProfile;
import io.kubernetes.client.openapi.models.V1SeccompProfileBuilder;
import io.kubernetes.client.openapi.models.V1SeccompProfileFluentImpl;
import io.kubernetes.client.openapi.models.V1Sysctl;
import io.kubernetes.client.openapi.models.V1SysctlBuilder;
import io.kubernetes.client.openapi.models.V1SysctlFluentImpl;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptions;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptionsBuilder;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptionsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class V1PodSecurityContextFluentImpl<A extends V1PodSecurityContextFluent<A>>
extends BaseFluent<A>
implements V1PodSecurityContextFluent<A> {
    private Long fsGroup;
    private String fsGroupChangePolicy;
    private Long runAsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private V1SELinuxOptionsBuilder seLinuxOptions;
    private V1SeccompProfileBuilder seccompProfile;
    private List<Long> supplementalGroups;
    private List<V1SysctlBuilder> sysctls;
    private V1WindowsSecurityContextOptionsBuilder windowsOptions;

    public V1PodSecurityContextFluentImpl() {
    }

    public V1PodSecurityContextFluentImpl(V1PodSecurityContext instance) {
        this.withFsGroup(instance.getFsGroup());
        this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
        this.withRunAsGroup(instance.getRunAsGroup());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
        this.withSeccompProfile(instance.getSeccompProfile());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withSysctls(instance.getSysctls());
        this.withWindowsOptions(instance.getWindowsOptions());
    }

    @Override
    public Long getFsGroup() {
        return this.fsGroup;
    }

    @Override
    public A withFsGroup(Long fsGroup) {
        this.fsGroup = fsGroup;
        return (A)this;
    }

    @Override
    public Boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    @Override
    public String getFsGroupChangePolicy() {
        return this.fsGroupChangePolicy;
    }

    @Override
    public A withFsGroupChangePolicy(String fsGroupChangePolicy) {
        this.fsGroupChangePolicy = fsGroupChangePolicy;
        return (A)this;
    }

    @Override
    public Boolean hasFsGroupChangePolicy() {
        return this.fsGroupChangePolicy != null;
    }

    @Override
    public A withNewFsGroupChangePolicy(String arg1) {
        return this.withFsGroupChangePolicy(new String(arg1));
    }

    @Override
    public A withNewFsGroupChangePolicy(StringBuilder arg1) {
        return this.withFsGroupChangePolicy(new String(arg1));
    }

    @Override
    public A withNewFsGroupChangePolicy(StringBuffer arg1) {
        return this.withFsGroupChangePolicy(new String(arg1));
    }

    @Override
    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    @Override
    public A withRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsGroup() {
        return this.runAsGroup != null;
    }

    @Override
    public Boolean isRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    @Override
    public A withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsNonRoot() {
        return this.runAsNonRoot != null;
    }

    @Override
    public A withNewRunAsNonRoot(String arg1) {
        return this.withRunAsNonRoot(new Boolean(arg1));
    }

    @Override
    public A withNewRunAsNonRoot(boolean arg1) {
        return this.withRunAsNonRoot(new Boolean(arg1));
    }

    @Override
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    @Override
    public A withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    @Override
    @Deprecated
    public V1SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    @Override
    public V1SELinuxOptions buildSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    @Override
    public A withSeLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this._visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
        if (seLinuxOptions != null) {
            this.seLinuxOptions = new V1SELinuxOptionsBuilder(seLinuxOptions);
            this._visitables.get("seLinuxOptions").add(this.seLinuxOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeLinuxOptions() {
        return this.seLinuxOptions != null;
    }

    @Override
    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNestedImpl();
    }

    @Override
    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(V1SELinuxOptions item) {
        return new SeLinuxOptionsNestedImpl(item);
    }

    @Override
    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions());
    }

    @Override
    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions() != null ? this.getSeLinuxOptions() : new V1SELinuxOptionsBuilder().build());
    }

    @Override
    public V1PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(V1SELinuxOptions item) {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions() != null ? this.getSeLinuxOptions() : item);
    }

    @Override
    @Deprecated
    public V1SeccompProfile getSeccompProfile() {
        return this.seccompProfile != null ? this.seccompProfile.build() : null;
    }

    @Override
    public V1SeccompProfile buildSeccompProfile() {
        return this.seccompProfile != null ? this.seccompProfile.build() : null;
    }

    @Override
    public A withSeccompProfile(V1SeccompProfile seccompProfile) {
        this._visitables.get("seccompProfile").remove(this.seccompProfile);
        if (seccompProfile != null) {
            this.seccompProfile = new V1SeccompProfileBuilder(seccompProfile);
            this._visitables.get("seccompProfile").add(this.seccompProfile);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeccompProfile() {
        return this.seccompProfile != null;
    }

    @Override
    public V1PodSecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfile() {
        return new SeccompProfileNestedImpl();
    }

    @Override
    public V1PodSecurityContextFluent.SeccompProfileNested<A> withNewSeccompProfileLike(V1SeccompProfile item) {
        return new SeccompProfileNestedImpl(item);
    }

    @Override
    public V1PodSecurityContextFluent.SeccompProfileNested<A> editSeccompProfile() {
        return this.withNewSeccompProfileLike(this.getSeccompProfile());
    }

    @Override
    public V1PodSecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfile() {
        return this.withNewSeccompProfileLike(this.getSeccompProfile() != null ? this.getSeccompProfile() : new V1SeccompProfileBuilder().build());
    }

    @Override
    public V1PodSecurityContextFluent.SeccompProfileNested<A> editOrNewSeccompProfileLike(V1SeccompProfile item) {
        return this.withNewSeccompProfileLike(this.getSeccompProfile() != null ? this.getSeccompProfile() : item);
    }

    @Override
    public A addToSupplementalGroups(int index, Long item) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSupplementalGroups(int index, Long item) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSupplementalGroups(Long ... items) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSupplementalGroups(Collection<Long> items) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSupplementalGroups(Long ... items) {
        for (Long item : items) {
            if (this.supplementalGroups == null) continue;
            this.supplementalGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSupplementalGroups(Collection<Long> items) {
        for (Long item : items) {
            if (this.supplementalGroups == null) continue;
            this.supplementalGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    @Override
    public Long getSupplementalGroup(int index) {
        return this.supplementalGroups.get(index);
    }

    @Override
    public Long getFirstSupplementalGroup() {
        return this.supplementalGroups.get(0);
    }

    @Override
    public Long getLastSupplementalGroup() {
        return this.supplementalGroups.get(this.supplementalGroups.size() - 1);
    }

    @Override
    public Long getMatchingSupplementalGroup(Predicate<Long> predicate) {
        for (Long item : this.supplementalGroups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSupplementalGroup(Predicate<Long> predicate) {
        for (Long item : this.supplementalGroups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSupplementalGroups(List<Long> supplementalGroups) {
        if (this.supplementalGroups != null) {
            this._visitables.get("supplementalGroups").removeAll(this.supplementalGroups);
        }
        if (supplementalGroups != null) {
            this.supplementalGroups = new ArrayList<Long>();
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        } else {
            this.supplementalGroups = null;
        }
        return (A)this;
    }

    @Override
    public A withSupplementalGroups(Long ... supplementalGroups) {
        if (this.supplementalGroups != null) {
            this.supplementalGroups.clear();
        }
        if (supplementalGroups != null) {
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSupplementalGroups() {
        return this.supplementalGroups != null && !this.supplementalGroups.isEmpty();
    }

    @Override
    public A addToSysctls(int index, V1Sysctl item) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<V1SysctlBuilder>();
        }
        V1SysctlBuilder builder = new V1SysctlBuilder(item);
        this._visitables.get("sysctls").add(index >= 0 ? index : this._visitables.get("sysctls").size(), builder);
        this.sysctls.add(index >= 0 ? index : this.sysctls.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSysctls(int index, V1Sysctl item) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<V1SysctlBuilder>();
        }
        V1SysctlBuilder builder = new V1SysctlBuilder(item);
        if (index < 0 || index >= this._visitables.get("sysctls").size()) {
            this._visitables.get("sysctls").add(builder);
        } else {
            this._visitables.get("sysctls").set(index, builder);
        }
        if (index < 0 || index >= this.sysctls.size()) {
            this.sysctls.add(builder);
        } else {
            this.sysctls.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSysctls(V1Sysctl ... items) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<V1SysctlBuilder>();
        }
        for (V1Sysctl item : items) {
            V1SysctlBuilder builder = new V1SysctlBuilder(item);
            this._visitables.get("sysctls").add(builder);
            this.sysctls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSysctls(Collection<V1Sysctl> items) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<V1SysctlBuilder>();
        }
        for (V1Sysctl item : items) {
            V1SysctlBuilder builder = new V1SysctlBuilder(item);
            this._visitables.get("sysctls").add(builder);
            this.sysctls.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSysctls(V1Sysctl ... items) {
        for (V1Sysctl item : items) {
            V1SysctlBuilder builder = new V1SysctlBuilder(item);
            this._visitables.get("sysctls").remove(builder);
            if (this.sysctls == null) continue;
            this.sysctls.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSysctls(Collection<V1Sysctl> items) {
        for (V1Sysctl item : items) {
            V1SysctlBuilder builder = new V1SysctlBuilder(item);
            this._visitables.get("sysctls").remove(builder);
            if (this.sysctls == null) continue;
            this.sysctls.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSysctls(Predicate<V1SysctlBuilder> predicate) {
        if (this.sysctls == null) {
            return (A)this;
        }
        Iterator<V1SysctlBuilder> each = this.sysctls.iterator();
        Object visitables = this._visitables.get("sysctls");
        while (each.hasNext()) {
            V1SysctlBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Sysctl> getSysctls() {
        return V1PodSecurityContextFluentImpl.build(this.sysctls);
    }

    @Override
    public List<V1Sysctl> buildSysctls() {
        return V1PodSecurityContextFluentImpl.build(this.sysctls);
    }

    @Override
    public V1Sysctl buildSysctl(int index) {
        return this.sysctls.get(index).build();
    }

    @Override
    public V1Sysctl buildFirstSysctl() {
        return this.sysctls.get(0).build();
    }

    @Override
    public V1Sysctl buildLastSysctl() {
        return this.sysctls.get(this.sysctls.size() - 1).build();
    }

    @Override
    public V1Sysctl buildMatchingSysctl(Predicate<V1SysctlBuilder> predicate) {
        for (V1SysctlBuilder item : this.sysctls) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSysctl(Predicate<V1SysctlBuilder> predicate) {
        for (V1SysctlBuilder item : this.sysctls) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSysctls(List<V1Sysctl> sysctls) {
        if (this.sysctls != null) {
            this._visitables.get("sysctls").removeAll(this.sysctls);
        }
        if (sysctls != null) {
            this.sysctls = new ArrayList<V1SysctlBuilder>();
            for (V1Sysctl item : sysctls) {
                this.addToSysctls(item);
            }
        } else {
            this.sysctls = null;
        }
        return (A)this;
    }

    @Override
    public A withSysctls(V1Sysctl ... sysctls) {
        if (this.sysctls != null) {
            this.sysctls.clear();
        }
        if (sysctls != null) {
            for (V1Sysctl item : sysctls) {
                this.addToSysctls(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSysctls() {
        return this.sysctls != null && !this.sysctls.isEmpty();
    }

    @Override
    public V1PodSecurityContextFluent.SysctlsNested<A> addNewSysctl() {
        return new SysctlsNestedImpl();
    }

    @Override
    public V1PodSecurityContextFluent.SysctlsNested<A> addNewSysctlLike(V1Sysctl item) {
        return new SysctlsNestedImpl(-1, item);
    }

    @Override
    public V1PodSecurityContextFluent.SysctlsNested<A> setNewSysctlLike(int index, V1Sysctl item) {
        return new SysctlsNestedImpl(index, item);
    }

    @Override
    public V1PodSecurityContextFluent.SysctlsNested<A> editSysctl(int index) {
        if (this.sysctls.size() <= index) {
            throw new RuntimeException("Can't edit sysctls. Index exceeds size.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    @Override
    public V1PodSecurityContextFluent.SysctlsNested<A> editFirstSysctl() {
        if (this.sysctls.size() == 0) {
            throw new RuntimeException("Can't edit first sysctls. The list is empty.");
        }
        return this.setNewSysctlLike(0, this.buildSysctl(0));
    }

    @Override
    public V1PodSecurityContextFluent.SysctlsNested<A> editLastSysctl() {
        int index = this.sysctls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sysctls. The list is empty.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    @Override
    public V1PodSecurityContextFluent.SysctlsNested<A> editMatchingSysctl(Predicate<V1SysctlBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sysctls.size(); ++i) {
            if (!predicate.apply(this.sysctls.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sysctls. No match found.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    @Override
    @Deprecated
    public V1WindowsSecurityContextOptions getWindowsOptions() {
        return this.windowsOptions != null ? this.windowsOptions.build() : null;
    }

    @Override
    public V1WindowsSecurityContextOptions buildWindowsOptions() {
        return this.windowsOptions != null ? this.windowsOptions.build() : null;
    }

    @Override
    public A withWindowsOptions(V1WindowsSecurityContextOptions windowsOptions) {
        this._visitables.get("windowsOptions").remove(this.windowsOptions);
        if (windowsOptions != null) {
            this.windowsOptions = new V1WindowsSecurityContextOptionsBuilder(windowsOptions);
            this._visitables.get("windowsOptions").add(this.windowsOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasWindowsOptions() {
        return this.windowsOptions != null;
    }

    @Override
    public V1PodSecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptions() {
        return new WindowsOptionsNestedImpl();
    }

    @Override
    public V1PodSecurityContextFluent.WindowsOptionsNested<A> withNewWindowsOptionsLike(V1WindowsSecurityContextOptions item) {
        return new WindowsOptionsNestedImpl(item);
    }

    @Override
    public V1PodSecurityContextFluent.WindowsOptionsNested<A> editWindowsOptions() {
        return this.withNewWindowsOptionsLike(this.getWindowsOptions());
    }

    @Override
    public V1PodSecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptions() {
        return this.withNewWindowsOptionsLike(this.getWindowsOptions() != null ? this.getWindowsOptions() : new V1WindowsSecurityContextOptionsBuilder().build());
    }

    @Override
    public V1PodSecurityContextFluent.WindowsOptionsNested<A> editOrNewWindowsOptionsLike(V1WindowsSecurityContextOptions item) {
        return this.withNewWindowsOptionsLike(this.getWindowsOptions() != null ? this.getWindowsOptions() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodSecurityContextFluentImpl that = (V1PodSecurityContextFluentImpl)o;
        if (this.fsGroup != null ? !this.fsGroup.equals(that.fsGroup) : that.fsGroup != null) {
            return false;
        }
        if (this.fsGroupChangePolicy != null ? !this.fsGroupChangePolicy.equals(that.fsGroupChangePolicy) : that.fsGroupChangePolicy != null) {
            return false;
        }
        if (this.runAsGroup != null ? !this.runAsGroup.equals(that.runAsGroup) : that.runAsGroup != null) {
            return false;
        }
        if (this.runAsNonRoot != null ? !this.runAsNonRoot.equals(that.runAsNonRoot) : that.runAsNonRoot != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinuxOptions != null ? !this.seLinuxOptions.equals(that.seLinuxOptions) : that.seLinuxOptions != null) {
            return false;
        }
        if (this.seccompProfile != null ? !this.seccompProfile.equals(that.seccompProfile) : that.seccompProfile != null) {
            return false;
        }
        if (this.supplementalGroups != null ? !this.supplementalGroups.equals(that.supplementalGroups) : that.supplementalGroups != null) {
            return false;
        }
        if (this.sysctls != null ? !this.sysctls.equals(that.sysctls) : that.sysctls != null) {
            return false;
        }
        return !(this.windowsOptions != null ? !this.windowsOptions.equals(that.windowsOptions) : that.windowsOptions != null);
    }

    public int hashCode() {
        return Objects.hash(this.fsGroup, this.fsGroupChangePolicy, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxOptions, this.seccompProfile, this.supplementalGroups, this.sysctls, this.windowsOptions, super.hashCode());
    }

    public class WindowsOptionsNestedImpl<N>
    extends V1WindowsSecurityContextOptionsFluentImpl<V1PodSecurityContextFluent.WindowsOptionsNested<N>>
    implements V1PodSecurityContextFluent.WindowsOptionsNested<N>,
    Nested<N> {
        private final V1WindowsSecurityContextOptionsBuilder builder;

        WindowsOptionsNestedImpl(V1WindowsSecurityContextOptions item) {
            this.builder = new V1WindowsSecurityContextOptionsBuilder(this, item);
        }

        WindowsOptionsNestedImpl() {
            this.builder = new V1WindowsSecurityContextOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSecurityContextFluentImpl.this.withWindowsOptions(this.builder.build());
        }

        @Override
        public N endWindowsOptions() {
            return this.and();
        }
    }

    public class SysctlsNestedImpl<N>
    extends V1SysctlFluentImpl<V1PodSecurityContextFluent.SysctlsNested<N>>
    implements V1PodSecurityContextFluent.SysctlsNested<N>,
    Nested<N> {
        private final V1SysctlBuilder builder;
        private final int index;

        SysctlsNestedImpl(int index, V1Sysctl item) {
            this.index = index;
            this.builder = new V1SysctlBuilder(this, item);
        }

        SysctlsNestedImpl() {
            this.index = -1;
            this.builder = new V1SysctlBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSecurityContextFluentImpl.this.setToSysctls(this.index, this.builder.build());
        }

        @Override
        public N endSysctl() {
            return this.and();
        }
    }

    public class SeccompProfileNestedImpl<N>
    extends V1SeccompProfileFluentImpl<V1PodSecurityContextFluent.SeccompProfileNested<N>>
    implements V1PodSecurityContextFluent.SeccompProfileNested<N>,
    Nested<N> {
        private final V1SeccompProfileBuilder builder;

        SeccompProfileNestedImpl(V1SeccompProfile item) {
            this.builder = new V1SeccompProfileBuilder(this, item);
        }

        SeccompProfileNestedImpl() {
            this.builder = new V1SeccompProfileBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSecurityContextFluentImpl.this.withSeccompProfile(this.builder.build());
        }

        @Override
        public N endSeccompProfile() {
            return this.and();
        }
    }

    public class SeLinuxOptionsNestedImpl<N>
    extends V1SELinuxOptionsFluentImpl<V1PodSecurityContextFluent.SeLinuxOptionsNested<N>>
    implements V1PodSecurityContextFluent.SeLinuxOptionsNested<N>,
    Nested<N> {
        private final V1SELinuxOptionsBuilder builder;

        SeLinuxOptionsNestedImpl(V1SELinuxOptions item) {
            this.builder = new V1SELinuxOptionsBuilder(this, item);
        }

        SeLinuxOptionsNestedImpl() {
            this.builder = new V1SELinuxOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodSecurityContextFluentImpl.this.withSeLinuxOptions(this.builder.build());
        }

        @Override
        public N endSeLinuxOptions() {
            return this.and();
        }
    }
}

