/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1alpha1LimitResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:  * How are requests for this priority level limited?  * What should be done with requests that exceed the limit?")
public class V1alpha1LimitedPriorityLevelConfiguration {
    public static final String SERIALIZED_NAME_ASSURED_CONCURRENCY_SHARES = "assuredConcurrencyShares";
    @SerializedName(value="assuredConcurrencyShares")
    private Integer assuredConcurrencyShares;
    public static final String SERIALIZED_NAME_LIMIT_RESPONSE = "limitResponse";
    @SerializedName(value="limitResponse")
    private V1alpha1LimitResponse limitResponse;

    public V1alpha1LimitedPriorityLevelConfiguration assuredConcurrencyShares(Integer assuredConcurrencyShares) {
        this.assuredConcurrencyShares = assuredConcurrencyShares;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`assuredConcurrencyShares` (ACS) configures the execution limit, which is a limit on the number of requests of this priority level that may be exeucting at a given time.  ACS must be a positive number. The server's concurrency limit (SCL) is divided among the concurrency-controlled priority levels in proportion to their assured concurrency shares. This produces the assured concurrency value (ACV) --- the number of requests that may be executing at a time --- for each such priority level:              ACV(l) = ceil( SCL * ACS(l) / ( sum[priority levels k] ACS(k) ) )  bigger numbers of ACS mean more reserved concurrent requests (at the expense of every other PL). This field has a default value of 30.")
    public Integer getAssuredConcurrencyShares() {
        return this.assuredConcurrencyShares;
    }

    public void setAssuredConcurrencyShares(Integer assuredConcurrencyShares) {
        this.assuredConcurrencyShares = assuredConcurrencyShares;
    }

    public V1alpha1LimitedPriorityLevelConfiguration limitResponse(V1alpha1LimitResponse limitResponse) {
        this.limitResponse = limitResponse;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha1LimitResponse getLimitResponse() {
        return this.limitResponse;
    }

    public void setLimitResponse(V1alpha1LimitResponse limitResponse) {
        this.limitResponse = limitResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1LimitedPriorityLevelConfiguration v1alpha1LimitedPriorityLevelConfiguration = (V1alpha1LimitedPriorityLevelConfiguration)o;
        return Objects.equals(this.assuredConcurrencyShares, v1alpha1LimitedPriorityLevelConfiguration.assuredConcurrencyShares) && Objects.equals(this.limitResponse, v1alpha1LimitedPriorityLevelConfiguration.limitResponse);
    }

    public int hashCode() {
        return Objects.hash(this.assuredConcurrencyShares, this.limitResponse);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1LimitedPriorityLevelConfiguration {\n");
        sb.append("    assuredConcurrencyShares: ").append(this.toIndentedString(this.assuredConcurrencyShares)).append("\n");
        sb.append("    limitResponse: ").append(this.toIndentedString(this.limitResponse)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

