/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@ApiModel(description="CertificateSigningRequestCondition describes a condition of a CertificateSigningRequest object")
public class V1CertificateSigningRequestCondition {
    public static final String SERIALIZED_NAME_LAST_TRANSITION_TIME = "lastTransitionTime";
    @SerializedName(value="lastTransitionTime")
    private DateTime lastTransitionTime;
    public static final String SERIALIZED_NAME_LAST_UPDATE_TIME = "lastUpdateTime";
    @SerializedName(value="lastUpdateTime")
    private DateTime lastUpdateTime;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public V1CertificateSigningRequestCondition lastTransitionTime(DateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="lastTransitionTime is the time the condition last transitioned from one status to another. If unset, when a new condition type is added or an existing condition's status is changed, the server defaults this to the current time.")
    public DateTime getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public void setLastTransitionTime(DateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    public V1CertificateSigningRequestCondition lastUpdateTime(DateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="lastUpdateTime is the time of the last update to this condition")
    public DateTime getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(DateTime lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public V1CertificateSigningRequestCondition message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="message contains a human readable message with details about the request state")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1CertificateSigningRequestCondition reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="reason indicates a brief reason for the request state")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1CertificateSigningRequestCondition status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="status of the condition, one of True, False, Unknown. Approved, Denied, and Failed conditions may not be \"False\" or \"Unknown\".")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public V1CertificateSigningRequestCondition type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="type of the condition. Known conditions are \"Approved\", \"Denied\", and \"Failed\".  An \"Approved\" condition is added via the /approval subresource, indicating the request was approved and should be issued by the signer.  A \"Denied\" condition is added via the /approval subresource, indicating the request was denied and should not be issued by the signer.  A \"Failed\" condition is added via the /status subresource, indicating the signer failed to issue the certificate.  Approved and Denied conditions are mutually exclusive. Approved, Denied, and Failed conditions cannot be removed once added.  Only one condition of a given type is allowed.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CertificateSigningRequestCondition v1CertificateSigningRequestCondition = (V1CertificateSigningRequestCondition)o;
        return Objects.equals(this.lastTransitionTime, v1CertificateSigningRequestCondition.lastTransitionTime) && Objects.equals(this.lastUpdateTime, v1CertificateSigningRequestCondition.lastUpdateTime) && Objects.equals(this.message, v1CertificateSigningRequestCondition.message) && Objects.equals(this.reason, v1CertificateSigningRequestCondition.reason) && Objects.equals(this.status, v1CertificateSigningRequestCondition.status) && Objects.equals(this.type, v1CertificateSigningRequestCondition.type);
    }

    public int hashCode() {
        return Objects.hash(this.lastTransitionTime, this.lastUpdateTime, this.message, this.reason, this.status, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CertificateSigningRequestCondition {\n");
        sb.append("    lastTransitionTime: ").append(this.toIndentedString(this.lastTransitionTime)).append("\n");
        sb.append("    lastUpdateTime: ").append(this.toIndentedString(this.lastUpdateTime)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

