/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1alpha1ServiceReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="AdmissionHookClientConfig contains the information to make a TLS connection with the webhook")
public class V1alpha1AdmissionHookClientConfig {
    @SerializedName(value="caBundle")
    private byte[] caBundle = null;
    @SerializedName(value="service")
    private V1alpha1ServiceReference service = null;

    public V1alpha1AdmissionHookClientConfig caBundle(byte[] caBundle) {
        this.caBundle = caBundle;
        return this;
    }

    @ApiModelProperty(required=true, value="CABundle is a PEM encoded CA bundle which will be used to validate webhook's server certificate. Required")
    public byte[] getCaBundle() {
        return this.caBundle;
    }

    public void setCaBundle(byte[] caBundle) {
        this.caBundle = caBundle;
    }

    public V1alpha1AdmissionHookClientConfig service(V1alpha1ServiceReference service) {
        this.service = service;
        return this;
    }

    @ApiModelProperty(required=true, value="Service is a reference to the service for this webhook. If there is only one port open for the service, that port will be used. If there are multiple ports open, port 443 will be used if it is open, otherwise it is an error. Required")
    public V1alpha1ServiceReference getService() {
        return this.service;
    }

    public void setService(V1alpha1ServiceReference service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1AdmissionHookClientConfig v1alpha1AdmissionHookClientConfig = (V1alpha1AdmissionHookClientConfig)o;
        return Objects.equals(this.caBundle, v1alpha1AdmissionHookClientConfig.caBundle) && Objects.equals(this.service, v1alpha1AdmissionHookClientConfig.service);
    }

    public int hashCode() {
        return Objects.hash(this.caBundle, this.service);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1AdmissionHookClientConfig {\n");
        sb.append("    caBundle: ").append(this.toIndentedString(this.caBundle)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

