/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LocalObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ScaleIOVolumeSource represents a persistent ScaleIO volume")
public class V1ScaleIOVolumeSource {
    @SerializedName(value="fsType")
    private String fsType = null;
    @SerializedName(value="gateway")
    private String gateway = null;
    @SerializedName(value="protectionDomain")
    private String protectionDomain = null;
    @SerializedName(value="readOnly")
    private Boolean readOnly = null;
    @SerializedName(value="secretRef")
    private V1LocalObjectReference secretRef = null;
    @SerializedName(value="sslEnabled")
    private Boolean sslEnabled = null;
    @SerializedName(value="storageMode")
    private String storageMode = null;
    @SerializedName(value="storagePool")
    private String storagePool = null;
    @SerializedName(value="system")
    private String system = null;
    @SerializedName(value="volumeName")
    private String volumeName = null;

    public V1ScaleIOVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1ScaleIOVolumeSource gateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @ApiModelProperty(required=true, value="The host address of the ScaleIO API Gateway.")
    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public V1ScaleIOVolumeSource protectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
        return this;
    }

    @ApiModelProperty(value="The name of the Protection Domain for the configured storage (defaults to \"default\").")
    public String getProtectionDomain() {
        return this.protectionDomain;
    }

    public void setProtectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
    }

    public V1ScaleIOVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiModelProperty(value="Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1ScaleIOVolumeSource secretRef(V1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @ApiModelProperty(required=true, value="SecretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.")
    public V1LocalObjectReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(V1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
    }

    public V1ScaleIOVolumeSource sslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    @ApiModelProperty(value="Flag to enable/disable SSL communication with Gateway, default false")
    public Boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public V1ScaleIOVolumeSource storageMode(String storageMode) {
        this.storageMode = storageMode;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the storage for a volume should be thick or thin (defaults to \"thin\").")
    public String getStorageMode() {
        return this.storageMode;
    }

    public void setStorageMode(String storageMode) {
        this.storageMode = storageMode;
    }

    public V1ScaleIOVolumeSource storagePool(String storagePool) {
        this.storagePool = storagePool;
        return this;
    }

    @ApiModelProperty(value="The Storage Pool associated with the protection domain (defaults to \"default\").")
    public String getStoragePool() {
        return this.storagePool;
    }

    public void setStoragePool(String storagePool) {
        this.storagePool = storagePool;
    }

    public V1ScaleIOVolumeSource system(String system) {
        this.system = system;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the storage system as configured in ScaleIO.")
    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public V1ScaleIOVolumeSource volumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    @ApiModelProperty(value="The name of a volume already created in the ScaleIO system that is associated with this volume source.")
    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ScaleIOVolumeSource v1ScaleIOVolumeSource = (V1ScaleIOVolumeSource)o;
        return Objects.equals(this.fsType, v1ScaleIOVolumeSource.fsType) && Objects.equals(this.gateway, v1ScaleIOVolumeSource.gateway) && Objects.equals(this.protectionDomain, v1ScaleIOVolumeSource.protectionDomain) && Objects.equals(this.readOnly, v1ScaleIOVolumeSource.readOnly) && Objects.equals(this.secretRef, v1ScaleIOVolumeSource.secretRef) && Objects.equals(this.sslEnabled, v1ScaleIOVolumeSource.sslEnabled) && Objects.equals(this.storageMode, v1ScaleIOVolumeSource.storageMode) && Objects.equals(this.storagePool, v1ScaleIOVolumeSource.storagePool) && Objects.equals(this.system, v1ScaleIOVolumeSource.system) && Objects.equals(this.volumeName, v1ScaleIOVolumeSource.volumeName);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.gateway, this.protectionDomain, this.readOnly, this.secretRef, this.sslEnabled, this.storageMode, this.storagePool, this.system, this.volumeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ScaleIOVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    gateway: ").append(this.toIndentedString(this.gateway)).append("\n");
        sb.append("    protectionDomain: ").append(this.toIndentedString(this.protectionDomain)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    sslEnabled: ").append(this.toIndentedString(this.sslEnabled)).append("\n");
        sb.append("    storageMode: ").append(this.toIndentedString(this.storageMode)).append("\n");
        sb.append("    storagePool: ").append(this.toIndentedString(this.storagePool)).append("\n");
        sb.append("    system: ").append(this.toIndentedString(this.system)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

