/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ObjectMeta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.  StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name.")
public class V1StorageClass {
    @SerializedName(value="allowVolumeExpansion")
    private Boolean allowVolumeExpansion = null;
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata = null;
    @SerializedName(value="mountOptions")
    private List<String> mountOptions = null;
    @SerializedName(value="parameters")
    private Map<String, String> parameters = null;
    @SerializedName(value="provisioner")
    private String provisioner = null;
    @SerializedName(value="reclaimPolicy")
    private String reclaimPolicy = null;

    public V1StorageClass allowVolumeExpansion(Boolean allowVolumeExpansion) {
        this.allowVolumeExpansion = allowVolumeExpansion;
        return this;
    }

    @ApiModelProperty(value="AllowVolumeExpansion shows whether the storage class allow volume expand")
    public Boolean isAllowVolumeExpansion() {
        return this.allowVolumeExpansion;
    }

    public void setAllowVolumeExpansion(Boolean allowVolumeExpansion) {
        this.allowVolumeExpansion = allowVolumeExpansion;
    }

    public V1StorageClass apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1StorageClass kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1StorageClass metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1StorageClass mountOptions(List<String> mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    public V1StorageClass addMountOptionsItem(String mountOptionsItem) {
        if (this.mountOptions == null) {
            this.mountOptions = new ArrayList<String>();
        }
        this.mountOptions.add(mountOptionsItem);
        return this;
    }

    @ApiModelProperty(value="Dynamically provisioned PersistentVolumes of this storage class are created with these mountOptions, e.g. [\"ro\", \"soft\"]. Not validated - mount of the PVs will simply fail if one is invalid.")
    public List<String> getMountOptions() {
        return this.mountOptions;
    }

    public void setMountOptions(List<String> mountOptions) {
        this.mountOptions = mountOptions;
    }

    public V1StorageClass parameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public V1StorageClass putParametersItem(String key, String parametersItem) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, parametersItem);
        return this;
    }

    @ApiModelProperty(value="Parameters holds the parameters for the provisioner that should create volumes of this storage class.")
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public V1StorageClass provisioner(String provisioner) {
        this.provisioner = provisioner;
        return this;
    }

    @ApiModelProperty(required=true, value="Provisioner indicates the type of the provisioner.")
    public String getProvisioner() {
        return this.provisioner;
    }

    public void setProvisioner(String provisioner) {
        this.provisioner = provisioner;
    }

    public V1StorageClass reclaimPolicy(String reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
        return this;
    }

    @ApiModelProperty(value="Dynamically provisioned PersistentVolumes of this storage class are created with this reclaimPolicy. Defaults to Delete.")
    public String getReclaimPolicy() {
        return this.reclaimPolicy;
    }

    public void setReclaimPolicy(String reclaimPolicy) {
        this.reclaimPolicy = reclaimPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1StorageClass v1StorageClass = (V1StorageClass)o;
        return Objects.equals(this.allowVolumeExpansion, v1StorageClass.allowVolumeExpansion) && Objects.equals(this.apiVersion, v1StorageClass.apiVersion) && Objects.equals(this.kind, v1StorageClass.kind) && Objects.equals(this.metadata, v1StorageClass.metadata) && Objects.equals(this.mountOptions, v1StorageClass.mountOptions) && Objects.equals(this.parameters, v1StorageClass.parameters) && Objects.equals(this.provisioner, v1StorageClass.provisioner) && Objects.equals(this.reclaimPolicy, v1StorageClass.reclaimPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.allowVolumeExpansion, this.apiVersion, this.kind, this.metadata, this.mountOptions, this.parameters, this.provisioner, this.reclaimPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1StorageClass {\n");
        sb.append("    allowVolumeExpansion: ").append(this.toIndentedString(this.allowVolumeExpansion)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    mountOptions: ").append(this.toIndentedString(this.mountOptions)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    provisioner: ").append(this.toIndentedString(this.provisioner)).append("\n");
        sb.append("    reclaimPolicy: ").append(this.toIndentedString(this.reclaimPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

