/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> tches that of any node on which a pod of the set of pods is running")
public class V1PodAffinityTerm {
    @SerializedName(value="labelSelector")
    private V1LabelSelector labelSelector = null;
    @SerializedName(value="namespaces")
    private List<String> namespaces = null;
    @SerializedName(value="topologyKey")
    private String topologyKey = null;

    public V1PodAffinityTerm labelSelector(V1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
        return this;
    }

    @ApiModelProperty(value="A label query over a set of resources, in this case pods.")
    public V1LabelSelector getLabelSelector() {
        return this.labelSelector;
    }

    public void setLabelSelector(V1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
    }

    public V1PodAffinityTerm namespaces(List<String> namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    public V1PodAffinityTerm addNamespacesItem(String namespacesItem) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(namespacesItem);
        return this;
    }

    @ApiModelProperty(value="namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means \"this pod's namespace\"")
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
    }

    public V1PodAffinityTerm topologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return this;
    }

    @ApiModelProperty(value="This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. For PreferredDuringScheduling pod anti-affinity, empty topologyKey is interpreted as \"all topologies\" (\"all topologies\" here means all the topologyKeys indicated by scheduler command-line argument --failure-domains); for affinity and for RequiredDuringScheduling pod anti-affinity, empty topologyKey is not allowed.")
    public String getTopologyKey() {
        return this.topologyKey;
    }

    public void setTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodAffinityTerm v1PodAffinityTerm = (V1PodAffinityTerm)o;
        return Objects.equals(this.labelSelector, v1PodAffinityTerm.labelSelector) && Objects.equals(this.namespaces, v1PodAffinityTerm.namespaces) && Objects.equals(this.topologyKey, v1PodAffinityTerm.topologyKey);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelector, this.namespaces, this.topologyKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodAffinityTerm {\n");
        sb.append("    labelSelector: ").append(this.toIndentedString(this.labelSelector)).append("\n");
        sb.append("    namespaces: ").append(this.toIndentedString(this.namespaces)).append("\n");
        sb.append("    topologyKey: ").append(this.toIndentedString(this.topologyKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

