/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.")
public class V2alpha1ResourceMetricStatus {
    @SerializedName(value="currentAverageUtilization")
    private Integer currentAverageUtilization = null;
    @SerializedName(value="currentAverageValue")
    private String currentAverageValue = null;
    @SerializedName(value="name")
    private String name = null;

    public V2alpha1ResourceMetricStatus currentAverageUtilization(Integer currentAverageUtilization) {
        this.currentAverageUtilization = currentAverageUtilization;
        return this;
    }

    @ApiModelProperty(value="currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.  It will only be present if `targetAverageValue` was set in the corresponding metric specification.")
    public Integer getCurrentAverageUtilization() {
        return this.currentAverageUtilization;
    }

    public void setCurrentAverageUtilization(Integer currentAverageUtilization) {
        this.currentAverageUtilization = currentAverageUtilization;
    }

    public V2alpha1ResourceMetricStatus currentAverageValue(String currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
        return this;
    }

    @ApiModelProperty(required=true, value="currentAverageValue is the the current value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type. It will always be set, regardless of the corresponding metric specification.")
    public String getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    public void setCurrentAverageValue(String currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
    }

    public V2alpha1ResourceMetricStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name is the name of the resource in question.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2alpha1ResourceMetricStatus v2alpha1ResourceMetricStatus = (V2alpha1ResourceMetricStatus)o;
        return Objects.equals(this.currentAverageUtilization, v2alpha1ResourceMetricStatus.currentAverageUtilization) && Objects.equals(this.currentAverageValue, v2alpha1ResourceMetricStatus.currentAverageValue) && Objects.equals(this.name, v2alpha1ResourceMetricStatus.name);
    }

    public int hashCode() {
        return Objects.hash(this.currentAverageUtilization, this.currentAverageValue, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2alpha1ResourceMetricStatus {\n");
        sb.append("    currentAverageUtilization: ").append(this.toIndentedString(this.currentAverageUtilization)).append("\n");
        sb.append("    currentAverageValue: ").append(this.toIndentedString(this.currentAverageValue)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

