/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V2alpha1ObjectMetricStatus;
import io.kubernetes.client.models.V2alpha1PodsMetricStatus;
import io.kubernetes.client.models.V2alpha1ResourceMetricStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="MetricStatus describes the last-read state of a single metric.")
public class V2alpha1MetricStatus {
    @SerializedName(value="object")
    private V2alpha1ObjectMetricStatus object = null;
    @SerializedName(value="pods")
    private V2alpha1PodsMetricStatus pods = null;
    @SerializedName(value="resource")
    private V2alpha1ResourceMetricStatus resource = null;
    @SerializedName(value="type")
    private String type = null;

    public V2alpha1MetricStatus object(V2alpha1ObjectMetricStatus object) {
        this.object = object;
        return this;
    }

    @ApiModelProperty(value="object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).")
    public V2alpha1ObjectMetricStatus getObject() {
        return this.object;
    }

    public void setObject(V2alpha1ObjectMetricStatus object) {
        this.object = object;
    }

    public V2alpha1MetricStatus pods(V2alpha1PodsMetricStatus pods) {
        this.pods = pods;
        return this;
    }

    @ApiModelProperty(value="pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.")
    public V2alpha1PodsMetricStatus getPods() {
        return this.pods;
    }

    public void setPods(V2alpha1PodsMetricStatus pods) {
        this.pods = pods;
    }

    public V2alpha1MetricStatus resource(V2alpha1ResourceMetricStatus resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(value="resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.")
    public V2alpha1ResourceMetricStatus getResource() {
        return this.resource;
    }

    public void setResource(V2alpha1ResourceMetricStatus resource) {
        this.resource = resource;
    }

    public V2alpha1MetricStatus type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="type is the type of metric source.  It will match one of the fields below.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2alpha1MetricStatus v2alpha1MetricStatus = (V2alpha1MetricStatus)o;
        return Objects.equals(this.object, v2alpha1MetricStatus.object) && Objects.equals(this.pods, v2alpha1MetricStatus.pods) && Objects.equals(this.resource, v2alpha1MetricStatus.resource) && Objects.equals(this.type, v2alpha1MetricStatus.type);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.pods, this.resource, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2alpha1MetricStatus {\n");
        sb.append("    object: ").append(this.toIndentedString(this.object)).append("\n");
        sb.append("    pods: ").append(this.toIndentedString(this.pods)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

