/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1beta1NonResourceAttributes;
import io.kubernetes.client.models.V1beta1ResourceAttributes;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="SubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set")
public class V1beta1SubjectAccessReviewSpec {
    @SerializedName(value="extra")
    private Map<String, List<String>> extra = null;
    @SerializedName(value="group")
    private List<String> group = null;
    @SerializedName(value="nonResourceAttributes")
    private V1beta1NonResourceAttributes nonResourceAttributes = null;
    @SerializedName(value="resourceAttributes")
    private V1beta1ResourceAttributes resourceAttributes = null;
    @SerializedName(value="user")
    private String user = null;

    public V1beta1SubjectAccessReviewSpec extra(Map<String, List<String>> extra) {
        this.extra = extra;
        return this;
    }

    public V1beta1SubjectAccessReviewSpec putExtraItem(String key, List<String> extraItem) {
        if (this.extra == null) {
            this.extra = new HashMap<String, List<String>>();
        }
        this.extra.put(key, extraItem);
        return this;
    }

    @ApiModelProperty(value="Extra corresponds to the user.Info.GetExtra() method from the authenticator.  Since that is input to the authorizer it needs a reflection here.")
    public Map<String, List<String>> getExtra() {
        return this.extra;
    }

    public void setExtra(Map<String, List<String>> extra) {
        this.extra = extra;
    }

    public V1beta1SubjectAccessReviewSpec group(List<String> group) {
        this.group = group;
        return this;
    }

    public V1beta1SubjectAccessReviewSpec addGroupItem(String groupItem) {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        this.group.add(groupItem);
        return this;
    }

    @ApiModelProperty(value="Groups is the groups you're testing for.")
    public List<String> getGroup() {
        return this.group;
    }

    public void setGroup(List<String> group) {
        this.group = group;
    }

    public V1beta1SubjectAccessReviewSpec nonResourceAttributes(V1beta1NonResourceAttributes nonResourceAttributes) {
        this.nonResourceAttributes = nonResourceAttributes;
        return this;
    }

    @ApiModelProperty(value="NonResourceAttributes describes information for a non-resource access request")
    public V1beta1NonResourceAttributes getNonResourceAttributes() {
        return this.nonResourceAttributes;
    }

    public void setNonResourceAttributes(V1beta1NonResourceAttributes nonResourceAttributes) {
        this.nonResourceAttributes = nonResourceAttributes;
    }

    public V1beta1SubjectAccessReviewSpec resourceAttributes(V1beta1ResourceAttributes resourceAttributes) {
        this.resourceAttributes = resourceAttributes;
        return this;
    }

    @ApiModelProperty(value="ResourceAuthorizationAttributes describes information for a resource access request")
    public V1beta1ResourceAttributes getResourceAttributes() {
        return this.resourceAttributes;
    }

    public void setResourceAttributes(V1beta1ResourceAttributes resourceAttributes) {
        this.resourceAttributes = resourceAttributes;
    }

    public V1beta1SubjectAccessReviewSpec user(String user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="User is the user you're testing for. If you specify \"User\" but not \"Group\", then is it interpreted as \"What if User were not a member of any groups")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1SubjectAccessReviewSpec v1beta1SubjectAccessReviewSpec = (V1beta1SubjectAccessReviewSpec)o;
        return Objects.equals(this.extra, v1beta1SubjectAccessReviewSpec.extra) && Objects.equals(this.group, v1beta1SubjectAccessReviewSpec.group) && Objects.equals(this.nonResourceAttributes, v1beta1SubjectAccessReviewSpec.nonResourceAttributes) && Objects.equals(this.resourceAttributes, v1beta1SubjectAccessReviewSpec.resourceAttributes) && Objects.equals(this.user, v1beta1SubjectAccessReviewSpec.user);
    }

    public int hashCode() {
        return Objects.hash(this.extra, this.group, this.nonResourceAttributes, this.resourceAttributes, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1SubjectAccessReviewSpec {\n");
        sb.append("    extra: ").append(this.toIndentedString(this.extra)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    nonResourceAttributes: ").append(this.toIndentedString(this.nonResourceAttributes)).append("\n");
        sb.append("    resourceAttributes: ").append(this.toIndentedString(this.resourceAttributes)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

