/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ReplicationControllerCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="ReplicationControllerStatus represents the current status of a replication controller.")
public class V1ReplicationControllerStatus {
    @SerializedName(value="availableReplicas")
    private Integer availableReplicas = null;
    @SerializedName(value="conditions")
    private List<V1ReplicationControllerCondition> conditions = null;
    @SerializedName(value="fullyLabeledReplicas")
    private Integer fullyLabeledReplicas = null;
    @SerializedName(value="observedGeneration")
    private Long observedGeneration = null;
    @SerializedName(value="readyReplicas")
    private Integer readyReplicas = null;
    @SerializedName(value="replicas")
    private Integer replicas = null;

    public V1ReplicationControllerStatus availableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    @ApiModelProperty(value="The number of available replicas (ready for at least minReadySeconds) for this replication controller.")
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public V1ReplicationControllerStatus conditions(List<V1ReplicationControllerCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1ReplicationControllerStatus addConditionsItem(V1ReplicationControllerCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1ReplicationControllerCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @ApiModelProperty(value="Represents the latest available observations of a replication controller's current state.")
    public List<V1ReplicationControllerCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1ReplicationControllerCondition> conditions) {
        this.conditions = conditions;
    }

    public V1ReplicationControllerStatus fullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
        return this;
    }

    @ApiModelProperty(value="The number of pods that have labels matching the labels of the pod template of the replication controller.")
    public Integer getFullyLabeledReplicas() {
        return this.fullyLabeledReplicas;
    }

    public void setFullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
    }

    public V1ReplicationControllerStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @ApiModelProperty(value="ObservedGeneration reflects the generation of the most recently observed replication controller.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1ReplicationControllerStatus readyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    @ApiModelProperty(value="The number of ready replicas for this replication controller.")
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public V1ReplicationControllerStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(required=true, value="Replicas is the most recently oberved number of replicas. More info: http://kubernetes.io/docs/user-guide/replication-controller#what-is-a-replication-controller")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ReplicationControllerStatus v1ReplicationControllerStatus = (V1ReplicationControllerStatus)o;
        return Objects.equals(this.availableReplicas, v1ReplicationControllerStatus.availableReplicas) && Objects.equals(this.conditions, v1ReplicationControllerStatus.conditions) && Objects.equals(this.fullyLabeledReplicas, v1ReplicationControllerStatus.fullyLabeledReplicas) && Objects.equals(this.observedGeneration, v1ReplicationControllerStatus.observedGeneration) && Objects.equals(this.readyReplicas, v1ReplicationControllerStatus.readyReplicas) && Objects.equals(this.replicas, v1ReplicationControllerStatus.replicas);
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.conditions, this.fullyLabeledReplicas, this.observedGeneration, this.readyReplicas, this.replicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ReplicationControllerStatus {\n");
        sb.append("    availableReplicas: ").append(this.toIndentedString(this.availableReplicas)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    fullyLabeledReplicas: ").append(this.toIndentedString(this.fullyLabeledReplicas)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    readyReplicas: ").append(this.toIndentedString(this.readyReplicas)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

