/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="OwnerReference contains enough information to let you identify an owning object. Currently, an owning object must be in the same namespace, so there is no namespace field.")
public class V1OwnerReference {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="blockOwnerDeletion")
    private Boolean blockOwnerDeletion = null;
    @SerializedName(value="controller")
    private Boolean controller = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="uid")
    private String uid = null;

    public V1OwnerReference apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="API version of the referent.")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1OwnerReference blockOwnerDeletion(Boolean blockOwnerDeletion) {
        this.blockOwnerDeletion = blockOwnerDeletion;
        return this;
    }

    @ApiModelProperty(value="If true, AND if the owner has the \"foregroundDeletion\" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs \"delete\" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.")
    public Boolean isBlockOwnerDeletion() {
        return this.blockOwnerDeletion;
    }

    public void setBlockOwnerDeletion(Boolean blockOwnerDeletion) {
        this.blockOwnerDeletion = blockOwnerDeletion;
    }

    public V1OwnerReference controller(Boolean controller) {
        this.controller = controller;
        return this;
    }

    @ApiModelProperty(value="If true, this reference points to the managing controller.")
    public Boolean isController() {
        return this.controller;
    }

    public void setController(Boolean controller) {
        this.controller = controller;
    }

    public V1OwnerReference kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(required=true, value="Kind of the referent. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1OwnerReference name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1OwnerReference uid(String uid) {
        this.uid = uid;
        return this;
    }

    @ApiModelProperty(required=true, value="UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids")
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1OwnerReference v1OwnerReference = (V1OwnerReference)o;
        return Objects.equals(this.apiVersion, v1OwnerReference.apiVersion) && Objects.equals(this.blockOwnerDeletion, v1OwnerReference.blockOwnerDeletion) && Objects.equals(this.controller, v1OwnerReference.controller) && Objects.equals(this.kind, v1OwnerReference.kind) && Objects.equals(this.name, v1OwnerReference.name) && Objects.equals(this.uid, v1OwnerReference.uid);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.blockOwnerDeletion, this.controller, this.kind, this.name, this.uid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1OwnerReference {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    blockOwnerDeletion: ").append(this.toIndentedString(this.blockOwnerDeletion)).append("\n");
        sb.append("    controller: ").append(this.toIndentedString(this.controller)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

