/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1Taint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="NodeSpec describes the attributes that a node is created with.")
public class V1NodeSpec {
    @SerializedName(value="externalID")
    private String externalID = null;
    @SerializedName(value="podCIDR")
    private String podCIDR = null;
    @SerializedName(value="providerID")
    private String providerID = null;
    @SerializedName(value="taints")
    private List<V1Taint> taints = null;
    @SerializedName(value="unschedulable")
    private Boolean unschedulable = null;

    public V1NodeSpec externalID(String externalID) {
        this.externalID = externalID;
        return this;
    }

    @ApiModelProperty(value="External ID of the node assigned by some machine database (e.g. a cloud provider). Deprecated.")
    public String getExternalID() {
        return this.externalID;
    }

    public void setExternalID(String externalID) {
        this.externalID = externalID;
    }

    public V1NodeSpec podCIDR(String podCIDR) {
        this.podCIDR = podCIDR;
        return this;
    }

    @ApiModelProperty(value="PodCIDR represents the pod IP range assigned to the node.")
    public String getPodCIDR() {
        return this.podCIDR;
    }

    public void setPodCIDR(String podCIDR) {
        this.podCIDR = podCIDR;
    }

    public V1NodeSpec providerID(String providerID) {
        this.providerID = providerID;
        return this;
    }

    @ApiModelProperty(value="ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>")
    public String getProviderID() {
        return this.providerID;
    }

    public void setProviderID(String providerID) {
        this.providerID = providerID;
    }

    public V1NodeSpec taints(List<V1Taint> taints) {
        this.taints = taints;
        return this;
    }

    public V1NodeSpec addTaintsItem(V1Taint taintsItem) {
        if (this.taints == null) {
            this.taints = new ArrayList<V1Taint>();
        }
        this.taints.add(taintsItem);
        return this;
    }

    @ApiModelProperty(value="If specified, the node's taints.")
    public List<V1Taint> getTaints() {
        return this.taints;
    }

    public void setTaints(List<V1Taint> taints) {
        this.taints = taints;
    }

    public V1NodeSpec unschedulable(Boolean unschedulable) {
        this.unschedulable = unschedulable;
        return this;
    }

    @ApiModelProperty(value="Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: http://releases.k8s.io/HEAD/docs/admin/node.md#manual-node-administration")
    public Boolean isUnschedulable() {
        return this.unschedulable;
    }

    public void setUnschedulable(Boolean unschedulable) {
        this.unschedulable = unschedulable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NodeSpec v1NodeSpec = (V1NodeSpec)o;
        return Objects.equals(this.externalID, v1NodeSpec.externalID) && Objects.equals(this.podCIDR, v1NodeSpec.podCIDR) && Objects.equals(this.providerID, v1NodeSpec.providerID) && Objects.equals(this.taints, v1NodeSpec.taints) && Objects.equals(this.unschedulable, v1NodeSpec.unschedulable);
    }

    public int hashCode() {
        return Objects.hash(this.externalID, this.podCIDR, this.providerID, this.taints, this.unschedulable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NodeSpec {\n");
        sb.append("    externalID: ").append(this.toIndentedString(this.externalID)).append("\n");
        sb.append("    podCIDR: ").append(this.toIndentedString(this.podCIDR)).append("\n");
        sb.append("    providerID: ").append(this.toIndentedString(this.providerID)).append("\n");
        sb.append("    taints: ").append(this.toIndentedString(this.taints)).append("\n");
        sb.append("    unschedulable: ").append(this.toIndentedString(this.unschedulable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

