/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1GroupVersionForDiscovery;
import io.kubernetes.client.models.V1ServerAddressByClientCIDR;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="APIGroup contains the name, the supported versions, and the preferred version of a group.")
public class V1APIGroup {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="preferredVersion")
    private V1GroupVersionForDiscovery preferredVersion = null;
    @SerializedName(value="serverAddressByClientCIDRs")
    private List<V1ServerAddressByClientCIDR> serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDR>();
    @SerializedName(value="versions")
    private List<V1GroupVersionForDiscovery> versions = new ArrayList<V1GroupVersionForDiscovery>();

    public V1APIGroup apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1APIGroup kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1APIGroup name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name is the name of the group.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1APIGroup preferredVersion(V1GroupVersionForDiscovery preferredVersion) {
        this.preferredVersion = preferredVersion;
        return this;
    }

    @ApiModelProperty(value="preferredVersion is the version preferred by the API server, which probably is the storage version.")
    public V1GroupVersionForDiscovery getPreferredVersion() {
        return this.preferredVersion;
    }

    public void setPreferredVersion(V1GroupVersionForDiscovery preferredVersion) {
        this.preferredVersion = preferredVersion;
    }

    public V1APIGroup serverAddressByClientCIDRs(List<V1ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
        return this;
    }

    public V1APIGroup addServerAddressByClientCIDRsItem(V1ServerAddressByClientCIDR serverAddressByClientCIDRsItem) {
        this.serverAddressByClientCIDRs.add(serverAddressByClientCIDRsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.")
    public List<V1ServerAddressByClientCIDR> getServerAddressByClientCIDRs() {
        return this.serverAddressByClientCIDRs;
    }

    public void setServerAddressByClientCIDRs(List<V1ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
    }

    public V1APIGroup versions(List<V1GroupVersionForDiscovery> versions) {
        this.versions = versions;
        return this;
    }

    public V1APIGroup addVersionsItem(V1GroupVersionForDiscovery versionsItem) {
        this.versions.add(versionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="versions are the versions supported in this group.")
    public List<V1GroupVersionForDiscovery> getVersions() {
        return this.versions;
    }

    public void setVersions(List<V1GroupVersionForDiscovery> versions) {
        this.versions = versions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIGroup v1APIGroup = (V1APIGroup)o;
        return Objects.equals(this.apiVersion, v1APIGroup.apiVersion) && Objects.equals(this.kind, v1APIGroup.kind) && Objects.equals(this.name, v1APIGroup.name) && Objects.equals(this.preferredVersion, v1APIGroup.preferredVersion) && Objects.equals(this.serverAddressByClientCIDRs, v1APIGroup.serverAddressByClientCIDRs) && Objects.equals(this.versions, v1APIGroup.versions);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.name, this.preferredVersion, this.serverAddressByClientCIDRs, this.versions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1APIGroup {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    preferredVersion: ").append(this.toIndentedString(this.preferredVersion)).append("\n");
        sb.append("    serverAddressByClientCIDRs: ").append(this.toIndentedString(this.serverAddressByClientCIDRs)).append("\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

