/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.ExtensionsV1beta1DeploymentStrategy;
import io.kubernetes.client.models.ExtensionsV1beta1RollbackConfig;
import io.kubernetes.client.models.V1LabelSelector;
import io.kubernetes.client.models.V1PodTemplateSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="DeploymentSpec is the specification of the desired behavior of the Deployment.")
public class ExtensionsV1beta1DeploymentSpec {
    @SerializedName(value="minReadySeconds")
    private Integer minReadySeconds = null;
    @SerializedName(value="paused")
    private Boolean paused = null;
    @SerializedName(value="progressDeadlineSeconds")
    private Integer progressDeadlineSeconds = null;
    @SerializedName(value="replicas")
    private Integer replicas = null;
    @SerializedName(value="revisionHistoryLimit")
    private Integer revisionHistoryLimit = null;
    @SerializedName(value="rollbackTo")
    private ExtensionsV1beta1RollbackConfig rollbackTo = null;
    @SerializedName(value="selector")
    private V1LabelSelector selector = null;
    @SerializedName(value="strategy")
    private ExtensionsV1beta1DeploymentStrategy strategy = null;
    @SerializedName(value="template")
    private V1PodTemplateSpec template = null;

    public ExtensionsV1beta1DeploymentSpec minReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    @ApiModelProperty(value="Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)")
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public ExtensionsV1beta1DeploymentSpec paused(Boolean paused) {
        this.paused = paused;
        return this;
    }

    @ApiModelProperty(value="Indicates that the deployment is paused and will not be processed by the deployment controller.")
    public Boolean isPaused() {
        return this.paused;
    }

    public void setPaused(Boolean paused) {
        this.paused = paused;
    }

    public ExtensionsV1beta1DeploymentSpec progressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.progressDeadlineSeconds = progressDeadlineSeconds;
        return this;
    }

    @ApiModelProperty(value="The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Once autoRollback is implemented, the deployment controller will automatically rollback failed deployments. Note that progress will not be estimated during the time a deployment is paused. This is not set by default.")
    public Integer getProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds;
    }

    public void setProgressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.progressDeadlineSeconds = progressDeadlineSeconds;
    }

    public ExtensionsV1beta1DeploymentSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(value="Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public ExtensionsV1beta1DeploymentSpec revisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return this;
    }

    @ApiModelProperty(value="The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified.")
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public void setRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
    }

    public ExtensionsV1beta1DeploymentSpec rollbackTo(ExtensionsV1beta1RollbackConfig rollbackTo) {
        this.rollbackTo = rollbackTo;
        return this;
    }

    @ApiModelProperty(value="The config this deployment is rolling back to. Will be cleared after rollback is done.")
    public ExtensionsV1beta1RollbackConfig getRollbackTo() {
        return this.rollbackTo;
    }

    public void setRollbackTo(ExtensionsV1beta1RollbackConfig rollbackTo) {
        this.rollbackTo = rollbackTo;
    }

    public ExtensionsV1beta1DeploymentSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(value="Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment.")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public ExtensionsV1beta1DeploymentSpec strategy(ExtensionsV1beta1DeploymentStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    @ApiModelProperty(value="The deployment strategy to use to replace existing pods with new ones.")
    public ExtensionsV1beta1DeploymentStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(ExtensionsV1beta1DeploymentStrategy strategy) {
        this.strategy = strategy;
    }

    public ExtensionsV1beta1DeploymentSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(required=true, value="Template describes the pods that will be created.")
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionsV1beta1DeploymentSpec extensionsV1beta1DeploymentSpec = (ExtensionsV1beta1DeploymentSpec)o;
        return Objects.equals(this.minReadySeconds, extensionsV1beta1DeploymentSpec.minReadySeconds) && Objects.equals(this.paused, extensionsV1beta1DeploymentSpec.paused) && Objects.equals(this.progressDeadlineSeconds, extensionsV1beta1DeploymentSpec.progressDeadlineSeconds) && Objects.equals(this.replicas, extensionsV1beta1DeploymentSpec.replicas) && Objects.equals(this.revisionHistoryLimit, extensionsV1beta1DeploymentSpec.revisionHistoryLimit) && Objects.equals(this.rollbackTo, extensionsV1beta1DeploymentSpec.rollbackTo) && Objects.equals(this.selector, extensionsV1beta1DeploymentSpec.selector) && Objects.equals(this.strategy, extensionsV1beta1DeploymentSpec.strategy) && Objects.equals(this.template, extensionsV1beta1DeploymentSpec.template);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.paused, this.progressDeadlineSeconds, this.replicas, this.revisionHistoryLimit, this.rollbackTo, this.selector, this.strategy, this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtensionsV1beta1DeploymentSpec {\n");
        sb.append("    minReadySeconds: ").append(this.toIndentedString(this.minReadySeconds)).append("\n");
        sb.append("    paused: ").append(this.toIndentedString(this.paused)).append("\n");
        sb.append("    progressDeadlineSeconds: ").append(this.toIndentedString(this.progressDeadlineSeconds)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    revisionHistoryLimit: ").append(this.toIndentedString(this.revisionHistoryLimit)).append("\n");
        sb.append("    rollbackTo: ").append(this.toIndentedString(this.rollbackTo)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    strategy: ").append(this.toIndentedString(this.strategy)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

