/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V2alpha1CrossVersionObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).")
public class V2alpha1ObjectMetricStatus {
    @SerializedName(value="currentValue")
    private String currentValue = null;
    @SerializedName(value="metricName")
    private String metricName = null;
    @SerializedName(value="target")
    private V2alpha1CrossVersionObjectReference target = null;

    public V2alpha1ObjectMetricStatus currentValue(String currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    @ApiModelProperty(required=true, value="currentValue is the current value of the metric (as a quantity).")
    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String currentValue) {
        this.currentValue = currentValue;
    }

    public V2alpha1ObjectMetricStatus metricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    @ApiModelProperty(required=true, value="metricName is the name of the metric in question.")
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public V2alpha1ObjectMetricStatus target(V2alpha1CrossVersionObjectReference target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(required=true, value="target is the described Kubernetes object.")
    public V2alpha1CrossVersionObjectReference getTarget() {
        return this.target;
    }

    public void setTarget(V2alpha1CrossVersionObjectReference target) {
        this.target = target;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2alpha1ObjectMetricStatus v2alpha1ObjectMetricStatus = (V2alpha1ObjectMetricStatus)o;
        return Objects.equals(this.currentValue, v2alpha1ObjectMetricStatus.currentValue) && Objects.equals(this.metricName, v2alpha1ObjectMetricStatus.metricName) && Objects.equals(this.target, v2alpha1ObjectMetricStatus.target);
    }

    public int hashCode() {
        return Objects.hash(this.currentValue, this.metricName, this.target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2alpha1ObjectMetricStatus {\n");
        sb.append("    currentValue: ").append(this.toIndentedString(this.currentValue)).append("\n");
        sb.append("    metricName: ").append(this.toIndentedString(this.metricName)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

