/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1beta1APIVersion;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A ThirdPartyResource is a generic representation of a resource, it is used by add-ons and plugins to add new resource types to the API.  It consists of one or more Versions of the api.")
public class V1beta1ThirdPartyResource {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata = null;
    @SerializedName(value="versions")
    private List<V1beta1APIVersion> versions = null;

    public V1beta1ThirdPartyResource apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1beta1ThirdPartyResource description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description is the description of this object.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public V1beta1ThirdPartyResource kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1beta1ThirdPartyResource metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Standard object metadata")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1beta1ThirdPartyResource versions(List<V1beta1APIVersion> versions) {
        this.versions = versions;
        return this;
    }

    public V1beta1ThirdPartyResource addVersionsItem(V1beta1APIVersion versionsItem) {
        if (this.versions == null) {
            this.versions = new ArrayList<V1beta1APIVersion>();
        }
        this.versions.add(versionsItem);
        return this;
    }

    @ApiModelProperty(value="Versions are versions for this third party object")
    public List<V1beta1APIVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<V1beta1APIVersion> versions) {
        this.versions = versions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1ThirdPartyResource v1beta1ThirdPartyResource = (V1beta1ThirdPartyResource)o;
        return Objects.equals(this.apiVersion, v1beta1ThirdPartyResource.apiVersion) && Objects.equals(this.description, v1beta1ThirdPartyResource.description) && Objects.equals(this.kind, v1beta1ThirdPartyResource.kind) && Objects.equals(this.metadata, v1beta1ThirdPartyResource.metadata) && Objects.equals(this.versions, v1beta1ThirdPartyResource.versions);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.description, this.kind, this.metadata, this.versions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1ThirdPartyResource {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

