/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="The node this Taint is attached to has the effect \"effect\" on any pod that that does not tolerate the Taint.")
public class V1Taint {
    @SerializedName(value="effect")
    private String effect = null;
    @SerializedName(value="key")
    private String key = null;
    @SerializedName(value="timeAdded")
    private DateTime timeAdded = null;
    @SerializedName(value="value")
    private String value = null;

    public V1Taint effect(String effect) {
        this.effect = effect;
        return this;
    }

    @ApiModelProperty(required=true, value="Required. The effect of the taint on pods that do not tolerate the taint. Valid effects are NoSchedule, PreferNoSchedule and NoExecute.")
    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public V1Taint key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="Required. The taint key to be applied to a node.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public V1Taint timeAdded(DateTime timeAdded) {
        this.timeAdded = timeAdded;
        return this;
    }

    @ApiModelProperty(value="TimeAdded represents the time at which the taint was added. It is only written for NoExecute taints.")
    public DateTime getTimeAdded() {
        return this.timeAdded;
    }

    public void setTimeAdded(DateTime timeAdded) {
        this.timeAdded = timeAdded;
    }

    public V1Taint value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="Required. The taint value corresponding to the taint key.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Taint v1Taint = (V1Taint)o;
        return Objects.equals(this.effect, v1Taint.effect) && Objects.equals(this.key, v1Taint.key) && Objects.equals(this.timeAdded, v1Taint.timeAdded) && Objects.equals(this.value, v1Taint.value);
    }

    public int hashCode() {
        return Objects.hash(this.effect, this.key, this.timeAdded, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Taint {\n");
        sb.append("    effect: ").append(this.toIndentedString(this.effect)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    timeAdded: ").append(this.toIndentedString(this.timeAdded)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

