/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ServicePort;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="ServiceSpec describes the attributes that a user creates on a service.")
public class V1ServiceSpec {
    @SerializedName(value="clusterIP")
    private String clusterIP = null;
    @SerializedName(value="deprecatedPublicIPs")
    private List<String> deprecatedPublicIPs = null;
    @SerializedName(value="externalIPs")
    private List<String> externalIPs = null;
    @SerializedName(value="externalName")
    private String externalName = null;
    @SerializedName(value="loadBalancerIP")
    private String loadBalancerIP = null;
    @SerializedName(value="loadBalancerSourceRanges")
    private List<String> loadBalancerSourceRanges = null;
    @SerializedName(value="ports")
    private List<V1ServicePort> ports = null;
    @SerializedName(value="selector")
    private Map<String, String> selector = null;
    @SerializedName(value="sessionAffinity")
    private String sessionAffinity = null;
    @SerializedName(value="type")
    private String type = null;

    public V1ServiceSpec clusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
        return this;
    }

    @ApiModelProperty(value="clusterIP is the IP address of the service and is usually assigned randomly by the master. If an address is specified manually and is not in use by others, it will be allocated to the service; otherwise, creation of the service will fail. This field can not be changed through updates. Valid values are \"None\", empty string (\"\"), or a valid IP address. \"None\" can be specified for headless services when proxying is not required. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: http://kubernetes.io/docs/user-guide/services#virtual-ips-and-service-proxies")
    public String getClusterIP() {
        return this.clusterIP;
    }

    public void setClusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
    }

    public V1ServiceSpec deprecatedPublicIPs(List<String> deprecatedPublicIPs) {
        this.deprecatedPublicIPs = deprecatedPublicIPs;
        return this;
    }

    public V1ServiceSpec addDeprecatedPublicIPsItem(String deprecatedPublicIPsItem) {
        if (this.deprecatedPublicIPs == null) {
            this.deprecatedPublicIPs = new ArrayList<String>();
        }
        this.deprecatedPublicIPs.add(deprecatedPublicIPsItem);
        return this;
    }

    @ApiModelProperty(value="deprecatedPublicIPs is deprecated and replaced by the externalIPs field with almost the exact same semantics.  This field is retained in the v1 API for compatibility until at least 8/20/2016.  It will be removed from any new API revisions.  If both deprecatedPublicIPs *and* externalIPs are set, deprecatedPublicIPs is used.")
    public List<String> getDeprecatedPublicIPs() {
        return this.deprecatedPublicIPs;
    }

    public void setDeprecatedPublicIPs(List<String> deprecatedPublicIPs) {
        this.deprecatedPublicIPs = deprecatedPublicIPs;
    }

    public V1ServiceSpec externalIPs(List<String> externalIPs) {
        this.externalIPs = externalIPs;
        return this;
    }

    public V1ServiceSpec addExternalIPsItem(String externalIPsItem) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        this.externalIPs.add(externalIPsItem);
        return this;
    }

    @ApiModelProperty(value="externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.  A previous form of this functionality exists as the deprecatedPublicIPs field.  When using this field, callers should also clear the deprecatedPublicIPs field.")
    public List<String> getExternalIPs() {
        return this.externalIPs;
    }

    public void setExternalIPs(List<String> externalIPs) {
        this.externalIPs = externalIPs;
    }

    public V1ServiceSpec externalName(String externalName) {
        this.externalName = externalName;
        return this;
    }

    @ApiModelProperty(value="externalName is the external reference that kubedns or equivalent will return as a CNAME record for this service. No proxying will be involved. Must be a valid DNS name and requires Type to be ExternalName.")
    public String getExternalName() {
        return this.externalName;
    }

    public void setExternalName(String externalName) {
        this.externalName = externalName;
    }

    public V1ServiceSpec loadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
        return this;
    }

    @ApiModelProperty(value="Only applies to Service Type: LoadBalancer LoadBalancer will get created with the IP specified in this field. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature.")
    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    public void setLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
    }

    public V1ServiceSpec loadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        this.loadBalancerSourceRanges = loadBalancerSourceRanges;
        return this;
    }

    public V1ServiceSpec addLoadBalancerSourceRangesItem(String loadBalancerSourceRangesItem) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        this.loadBalancerSourceRanges.add(loadBalancerSourceRangesItem);
        return this;
    }

    @ApiModelProperty(value="If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature.\" More info: http://kubernetes.io/docs/user-guide/services-firewalls")
    public List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    public void setLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        this.loadBalancerSourceRanges = loadBalancerSourceRanges;
    }

    public V1ServiceSpec ports(List<V1ServicePort> ports) {
        this.ports = ports;
        return this;
    }

    public V1ServiceSpec addPortsItem(V1ServicePort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1ServicePort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @ApiModelProperty(value="The list of ports that are exposed by this service. More info: http://kubernetes.io/docs/user-guide/services#virtual-ips-and-service-proxies")
    public List<V1ServicePort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<V1ServicePort> ports) {
        this.ports = ports;
    }

    public V1ServiceSpec selector(Map<String, String> selector) {
        this.selector = selector;
        return this;
    }

    public V1ServiceSpec putSelectorItem(String key, String selectorItem) {
        if (this.selector == null) {
            this.selector = new HashMap<String, String>();
        }
        this.selector.put(key, selectorItem);
        return this;
    }

    @ApiModelProperty(value="Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: http://kubernetes.io/docs/user-guide/services#overview")
    public Map<String, String> getSelector() {
        return this.selector;
    }

    public void setSelector(Map<String, String> selector) {
        this.selector = selector;
    }

    public V1ServiceSpec sessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
        return this;
    }

    @ApiModelProperty(value="Supports \"ClientIP\" and \"None\". Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: http://kubernetes.io/docs/user-guide/services#virtual-ips-and-service-proxies")
    public String getSessionAffinity() {
        return this.sessionAffinity;
    }

    public void setSessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
    }

    public V1ServiceSpec type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. \"ExternalName\" maps to the specified externalName. \"ClusterIP\" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object. If clusterIP is \"None\", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a stable IP. \"NodePort\" builds on ClusterIP and allocates a port on every node which routes to the clusterIP. \"LoadBalancer\" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the clusterIP. More info: http://kubernetes.io/docs/user-guide/services#overview")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ServiceSpec v1ServiceSpec = (V1ServiceSpec)o;
        return Objects.equals(this.clusterIP, v1ServiceSpec.clusterIP) && Objects.equals(this.deprecatedPublicIPs, v1ServiceSpec.deprecatedPublicIPs) && Objects.equals(this.externalIPs, v1ServiceSpec.externalIPs) && Objects.equals(this.externalName, v1ServiceSpec.externalName) && Objects.equals(this.loadBalancerIP, v1ServiceSpec.loadBalancerIP) && Objects.equals(this.loadBalancerSourceRanges, v1ServiceSpec.loadBalancerSourceRanges) && Objects.equals(this.ports, v1ServiceSpec.ports) && Objects.equals(this.selector, v1ServiceSpec.selector) && Objects.equals(this.sessionAffinity, v1ServiceSpec.sessionAffinity) && Objects.equals(this.type, v1ServiceSpec.type);
    }

    public int hashCode() {
        return Objects.hash(this.clusterIP, this.deprecatedPublicIPs, this.externalIPs, this.externalName, this.loadBalancerIP, this.loadBalancerSourceRanges, this.ports, this.selector, this.sessionAffinity, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ServiceSpec {\n");
        sb.append("    clusterIP: ").append(this.toIndentedString(this.clusterIP)).append("\n");
        sb.append("    deprecatedPublicIPs: ").append(this.toIndentedString(this.deprecatedPublicIPs)).append("\n");
        sb.append("    externalIPs: ").append(this.toIndentedString(this.externalIPs)).append("\n");
        sb.append("    externalName: ").append(this.toIndentedString(this.externalName)).append("\n");
        sb.append("    loadBalancerIP: ").append(this.toIndentedString(this.loadBalancerIP)).append("\n");
        sb.append("    loadBalancerSourceRanges: ").append(this.toIndentedString(this.loadBalancerSourceRanges)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    sessionAffinity: ").append(this.toIndentedString(this.sessionAffinity)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

