/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1Capabilities;
import io.kubernetes.client.models.V1SELinuxOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext.  When both are set, the values in SecurityContext take precedence.")
public class V1SecurityContext {
    @SerializedName(value="capabilities")
    private V1Capabilities capabilities = null;
    @SerializedName(value="privileged")
    private Boolean privileged = null;
    @SerializedName(value="readOnlyRootFilesystem")
    private Boolean readOnlyRootFilesystem = null;
    @SerializedName(value="runAsNonRoot")
    private Boolean runAsNonRoot = null;
    @SerializedName(value="runAsUser")
    private Long runAsUser = null;
    @SerializedName(value="seLinuxOptions")
    private V1SELinuxOptions seLinuxOptions = null;

    public V1SecurityContext capabilities(V1Capabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    @ApiModelProperty(value="The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime.")
    public V1Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(V1Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public V1SecurityContext privileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    @ApiModelProperty(value="Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.")
    public Boolean isPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public V1SecurityContext readOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return this;
    }

    @ApiModelProperty(value="Whether this container has a read-only root filesystem. Default is false.")
    public Boolean isReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public void setReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
    }

    public V1SecurityContext runAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return this;
    }

    @ApiModelProperty(value="Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    public Boolean isRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public void setRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    public V1SecurityContext runAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    @ApiModelProperty(value="The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    public V1SecurityContext seLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
        return this;
    }

    @ApiModelProperty(value="The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    public V1SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions;
    }

    public void setSeLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SecurityContext v1SecurityContext = (V1SecurityContext)o;
        return Objects.equals(this.capabilities, v1SecurityContext.capabilities) && Objects.equals(this.privileged, v1SecurityContext.privileged) && Objects.equals(this.readOnlyRootFilesystem, v1SecurityContext.readOnlyRootFilesystem) && Objects.equals(this.runAsNonRoot, v1SecurityContext.runAsNonRoot) && Objects.equals(this.runAsUser, v1SecurityContext.runAsUser) && Objects.equals(this.seLinuxOptions, v1SecurityContext.seLinuxOptions);
    }

    public int hashCode() {
        return Objects.hash(this.capabilities, this.privileged, this.readOnlyRootFilesystem, this.runAsNonRoot, this.runAsUser, this.seLinuxOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1SecurityContext {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    privileged: ").append(this.toIndentedString(this.privileged)).append("\n");
        sb.append("    readOnlyRootFilesystem: ").append(this.toIndentedString(this.readOnlyRootFilesystem)).append("\n");
        sb.append("    runAsNonRoot: ").append(this.toIndentedString(this.runAsNonRoot)).append("\n");
        sb.append("    runAsUser: ").append(this.toIndentedString(this.runAsUser)).append("\n");
        sb.append("    seLinuxOptions: ").append(this.toIndentedString(this.seLinuxOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

