/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ContainerStatus;
import io.kubernetes.client.models.V1PodCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="PodStatus represents information about the status of a pod. Status may trail the actual state of a system.")
public class V1PodStatus {
    @SerializedName(value="conditions")
    private List<V1PodCondition> conditions = null;
    @SerializedName(value="containerStatuses")
    private List<V1ContainerStatus> containerStatuses = null;
    @SerializedName(value="hostIP")
    private String hostIP = null;
    @SerializedName(value="initContainerStatuses")
    private List<V1ContainerStatus> initContainerStatuses = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="phase")
    private String phase = null;
    @SerializedName(value="podIP")
    private String podIP = null;
    @SerializedName(value="qosClass")
    private String qosClass = null;
    @SerializedName(value="reason")
    private String reason = null;
    @SerializedName(value="startTime")
    private DateTime startTime = null;

    public V1PodStatus conditions(List<V1PodCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1PodStatus addConditionsItem(V1PodCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1PodCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @ApiModelProperty(value="Current service state of pod. More info: http://kubernetes.io/docs/user-guide/pod-states#pod-conditions")
    public List<V1PodCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1PodCondition> conditions) {
        this.conditions = conditions;
    }

    public V1PodStatus containerStatuses(List<V1ContainerStatus> containerStatuses) {
        this.containerStatuses = containerStatuses;
        return this;
    }

    public V1PodStatus addContainerStatusesItem(V1ContainerStatus containerStatusesItem) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<V1ContainerStatus>();
        }
        this.containerStatuses.add(containerStatusesItem);
        return this;
    }

    @ApiModelProperty(value="The list has one entry per container in the manifest. Each entry is currently the output of `docker inspect`. More info: http://kubernetes.io/docs/user-guide/pod-states#container-statuses")
    public List<V1ContainerStatus> getContainerStatuses() {
        return this.containerStatuses;
    }

    public void setContainerStatuses(List<V1ContainerStatus> containerStatuses) {
        this.containerStatuses = containerStatuses;
    }

    public V1PodStatus hostIP(String hostIP) {
        this.hostIP = hostIP;
        return this;
    }

    @ApiModelProperty(value="IP address of the host to which the pod is assigned. Empty if not yet scheduled.")
    public String getHostIP() {
        return this.hostIP;
    }

    public void setHostIP(String hostIP) {
        this.hostIP = hostIP;
    }

    public V1PodStatus initContainerStatuses(List<V1ContainerStatus> initContainerStatuses) {
        this.initContainerStatuses = initContainerStatuses;
        return this;
    }

    public V1PodStatus addInitContainerStatusesItem(V1ContainerStatus initContainerStatusesItem) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList<V1ContainerStatus>();
        }
        this.initContainerStatuses.add(initContainerStatusesItem);
        return this;
    }

    @ApiModelProperty(value="The list has one entry per init container in the manifest. The most recent successful init container will have ready = true, the most recently started container will have startTime set. More info: http://kubernetes.io/docs/user-guide/pod-states#container-statuses")
    public List<V1ContainerStatus> getInitContainerStatuses() {
        return this.initContainerStatuses;
    }

    public void setInitContainerStatuses(List<V1ContainerStatus> initContainerStatuses) {
        this.initContainerStatuses = initContainerStatuses;
    }

    public V1PodStatus message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="A human readable message indicating details about why the pod is in this condition.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1PodStatus phase(String phase) {
        this.phase = phase;
        return this;
    }

    @ApiModelProperty(value="Current condition of the pod. More info: http://kubernetes.io/docs/user-guide/pod-states#pod-phase")
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public V1PodStatus podIP(String podIP) {
        this.podIP = podIP;
        return this;
    }

    @ApiModelProperty(value="IP address allocated to the pod. Routable at least within the cluster. Empty if not yet allocated.")
    public String getPodIP() {
        return this.podIP;
    }

    public void setPodIP(String podIP) {
        this.podIP = podIP;
    }

    public V1PodStatus qosClass(String qosClass) {
        this.qosClass = qosClass;
        return this;
    }

    @ApiModelProperty(value="The Quality of Service (QOS) classification assigned to the pod based on resource requirements See PodQOSClass type for available QOS classes More info: https://github.com/kubernetes/kubernetes/blob/master/docs/design/resource-qos.md")
    public String getQosClass() {
        return this.qosClass;
    }

    public void setQosClass(String qosClass) {
        this.qosClass = qosClass;
    }

    public V1PodStatus reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="A brief CamelCase message indicating details about why the pod is in this state. e.g. 'OutOfDisk'")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1PodStatus startTime(DateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(value="RFC 3339 date and time at which the object was acknowledged by the Kubelet. This is before the Kubelet pulled the container image(s) for the pod.")
    public DateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(DateTime startTime) {
        this.startTime = startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodStatus v1PodStatus = (V1PodStatus)o;
        return Objects.equals(this.conditions, v1PodStatus.conditions) && Objects.equals(this.containerStatuses, v1PodStatus.containerStatuses) && Objects.equals(this.hostIP, v1PodStatus.hostIP) && Objects.equals(this.initContainerStatuses, v1PodStatus.initContainerStatuses) && Objects.equals(this.message, v1PodStatus.message) && Objects.equals(this.phase, v1PodStatus.phase) && Objects.equals(this.podIP, v1PodStatus.podIP) && Objects.equals(this.qosClass, v1PodStatus.qosClass) && Objects.equals(this.reason, v1PodStatus.reason) && Objects.equals(this.startTime, v1PodStatus.startTime);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.containerStatuses, this.hostIP, this.initContainerStatuses, this.message, this.phase, this.podIP, this.qosClass, this.reason, this.startTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodStatus {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    containerStatuses: ").append(this.toIndentedString(this.containerStatuses)).append("\n");
        sb.append("    hostIP: ").append(this.toIndentedString(this.hostIP)).append("\n");
        sb.append("    initContainerStatuses: ").append(this.toIndentedString(this.initContainerStatuses)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString(this.phase)).append("\n");
        sb.append("    podIP: ").append(this.toIndentedString(this.podIP)).append("\n");
        sb.append("    qosClass: ").append(this.toIndentedString(this.qosClass)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

