/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="PersistentVolumeClaimStatus is the current status of a persistent volume claim.")
public class V1PersistentVolumeClaimStatus {
    @SerializedName(value="accessModes")
    private List<String> accessModes = null;
    @SerializedName(value="capacity")
    private Map<String, String> capacity = null;
    @SerializedName(value="phase")
    private String phase = null;

    public V1PersistentVolumeClaimStatus accessModes(List<String> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public V1PersistentVolumeClaimStatus addAccessModesItem(String accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    @ApiModelProperty(value="AccessModes contains the actual access modes the volume backing the PVC has. More info: http://kubernetes.io/docs/user-guide/persistent-volumes#access-modes-1")
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<String> accessModes) {
        this.accessModes = accessModes;
    }

    public V1PersistentVolumeClaimStatus capacity(Map<String, String> capacity) {
        this.capacity = capacity;
        return this;
    }

    public V1PersistentVolumeClaimStatus putCapacityItem(String key, String capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, String>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    @ApiModelProperty(value="Represents the actual resources of the underlying volume.")
    public Map<String, String> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Map<String, String> capacity) {
        this.capacity = capacity;
    }

    public V1PersistentVolumeClaimStatus phase(String phase) {
        this.phase = phase;
        return this;
    }

    @ApiModelProperty(value="Phase represents the current phase of PersistentVolumeClaim.")
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PersistentVolumeClaimStatus v1PersistentVolumeClaimStatus = (V1PersistentVolumeClaimStatus)o;
        return Objects.equals(this.accessModes, v1PersistentVolumeClaimStatus.accessModes) && Objects.equals(this.capacity, v1PersistentVolumeClaimStatus.capacity) && Objects.equals(this.phase, v1PersistentVolumeClaimStatus.phase);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.capacity, this.phase);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PersistentVolumeClaimStatus {\n");
        sb.append("    accessModes: ").append(this.toIndentedString(this.accessModes)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString(this.phase)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

