/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1APIGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="APIGroupList is a list of APIGroup, to allow clients to discover the API at /apis.")
public class V1APIGroupList {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="groups")
    private List<V1APIGroup> groups = new ArrayList<V1APIGroup>();
    @SerializedName(value="kind")
    private String kind = null;

    public V1APIGroupList apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1APIGroupList groups(List<V1APIGroup> groups) {
        this.groups = groups;
        return this;
    }

    public V1APIGroupList addGroupsItem(V1APIGroup groupsItem) {
        this.groups.add(groupsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="groups is a list of APIGroup.")
    public List<V1APIGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(List<V1APIGroup> groups) {
        this.groups = groups;
    }

    public V1APIGroupList kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIGroupList v1APIGroupList = (V1APIGroupList)o;
        return Objects.equals(this.apiVersion, v1APIGroupList.apiVersion) && Objects.equals(this.groups, v1APIGroupList.groups) && Objects.equals(this.kind, v1APIGroupList.kind);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groups, this.kind);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1APIGroupList {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

