/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V2CrossVersionObjectReference;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerBehavior;
import io.kubernetes.client.openapi.models.V2MetricSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.")
public class V2HorizontalPodAutoscalerSpec {
    public static final String SERIALIZED_NAME_BEHAVIOR = "behavior";
    @SerializedName(value="behavior")
    @Nullable
    private V2HorizontalPodAutoscalerBehavior behavior;
    public static final String SERIALIZED_NAME_MAX_REPLICAS = "maxReplicas";
    @SerializedName(value="maxReplicas")
    @Nonnull
    private Integer maxReplicas;
    public static final String SERIALIZED_NAME_METRICS = "metrics";
    @SerializedName(value="metrics")
    @Nullable
    private List<V2MetricSpec> metrics = new ArrayList<V2MetricSpec>();
    public static final String SERIALIZED_NAME_MIN_REPLICAS = "minReplicas";
    @SerializedName(value="minReplicas")
    @Nullable
    private Integer minReplicas;
    public static final String SERIALIZED_NAME_SCALE_TARGET_REF = "scaleTargetRef";
    @SerializedName(value="scaleTargetRef")
    @Nonnull
    private V2CrossVersionObjectReference scaleTargetRef;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V2HorizontalPodAutoscalerSpec behavior(@Nullable V2HorizontalPodAutoscalerBehavior behavior) {
        this.behavior = behavior;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V2HorizontalPodAutoscalerBehavior getBehavior() {
        return this.behavior;
    }

    public void setBehavior(@Nullable V2HorizontalPodAutoscalerBehavior behavior) {
        this.behavior = behavior;
    }

    public V2HorizontalPodAutoscalerSpec maxReplicas(@Nonnull Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.")
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public void setMaxReplicas(@Nonnull Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
    }

    public V2HorizontalPodAutoscalerSpec metrics(@Nullable List<V2MetricSpec> metrics) {
        this.metrics = metrics;
        return this;
    }

    public V2HorizontalPodAutoscalerSpec addMetricsItem(V2MetricSpec metricsItem) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<V2MetricSpec>();
        }
        this.metrics.add(metricsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.")
    public List<V2MetricSpec> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(@Nullable List<V2MetricSpec> metrics) {
        this.metrics = metrics;
    }

    public V2HorizontalPodAutoscalerSpec minReplicas(@Nullable Integer minReplicas) {
        this.minReplicas = minReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.")
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public void setMinReplicas(@Nullable Integer minReplicas) {
        this.minReplicas = minReplicas;
    }

    public V2HorizontalPodAutoscalerSpec scaleTargetRef(@Nonnull V2CrossVersionObjectReference scaleTargetRef) {
        this.scaleTargetRef = scaleTargetRef;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V2CrossVersionObjectReference getScaleTargetRef() {
        return this.scaleTargetRef;
    }

    public void setScaleTargetRef(@Nonnull V2CrossVersionObjectReference scaleTargetRef) {
        this.scaleTargetRef = scaleTargetRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2HorizontalPodAutoscalerSpec v2HorizontalPodAutoscalerSpec = (V2HorizontalPodAutoscalerSpec)o;
        return Objects.equals(this.behavior, v2HorizontalPodAutoscalerSpec.behavior) && Objects.equals(this.maxReplicas, v2HorizontalPodAutoscalerSpec.maxReplicas) && Objects.equals(this.metrics, v2HorizontalPodAutoscalerSpec.metrics) && Objects.equals(this.minReplicas, v2HorizontalPodAutoscalerSpec.minReplicas) && Objects.equals(this.scaleTargetRef, v2HorizontalPodAutoscalerSpec.scaleTargetRef);
    }

    public int hashCode() {
        return Objects.hash(this.behavior, this.maxReplicas, this.metrics, this.minReplicas, this.scaleTargetRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2HorizontalPodAutoscalerSpec {\n");
        sb.append("    behavior: ").append(this.toIndentedString(this.behavior)).append("\n");
        sb.append("    maxReplicas: ").append(this.toIndentedString(this.maxReplicas)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    minReplicas: ").append(this.toIndentedString(this.minReplicas)).append("\n");
        sb.append("    scaleTargetRef: ").append(this.toIndentedString(this.scaleTargetRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraymetrics;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V2HorizontalPodAutoscalerSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V2HorizontalPodAutoscalerSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_BEHAVIOR) != null && !jsonObj.get(SERIALIZED_NAME_BEHAVIOR).isJsonNull()) {
            V2HorizontalPodAutoscalerBehavior.validateJsonElement(jsonObj.get(SERIALIZED_NAME_BEHAVIOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_METRICS) != null && !jsonObj.get(SERIALIZED_NAME_METRICS).isJsonNull() && (jsonArraymetrics = jsonObj.getAsJsonArray(SERIALIZED_NAME_METRICS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_METRICS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `metrics` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_METRICS).toString()));
            }
            for (int i = 0; i < jsonArraymetrics.size(); ++i) {
                V2MetricSpec.validateJsonElement(jsonArraymetrics.get(i));
            }
        }
        V2CrossVersionObjectReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SCALE_TARGET_REF));
    }

    public static V2HorizontalPodAutoscalerSpec fromJson(String jsonString) throws IOException {
        return (V2HorizontalPodAutoscalerSpec)JSON.getGson().fromJson(jsonString, V2HorizontalPodAutoscalerSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BEHAVIOR);
        openapiFields.add(SERIALIZED_NAME_MAX_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_METRICS);
        openapiFields.add(SERIALIZED_NAME_MIN_REPLICAS);
        openapiFields.add(SERIALIZED_NAME_SCALE_TARGET_REF);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_MAX_REPLICAS);
        openapiRequiredFields.add(SERIALIZED_NAME_SCALE_TARGET_REF);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V2HorizontalPodAutoscalerSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V2HorizontalPodAutoscalerSpec.class));
            return new TypeAdapter<V2HorizontalPodAutoscalerSpec>(){

                public void write(JsonWriter out, V2HorizontalPodAutoscalerSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V2HorizontalPodAutoscalerSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V2HorizontalPodAutoscalerSpec.validateJsonElement(jsonElement);
                    return (V2HorizontalPodAutoscalerSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

