/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceFluent;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.kubernetes.client.openapi.models.V1ObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1ObjectReferenceFluent;
import io.kubernetes.client.openapi.models.V1ServiceAccount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1ServiceAccountFluent<A extends V1ServiceAccountFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private Boolean automountServiceAccountToken;
    private ArrayList<V1LocalObjectReferenceBuilder> imagePullSecrets;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private ArrayList<V1ObjectReferenceBuilder> secrets;

    public V1ServiceAccountFluent() {
    }

    public V1ServiceAccountFluent(V1ServiceAccount instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ServiceAccount instance) {
        V1ServiceAccount v1ServiceAccount = instance = instance != null ? instance : new V1ServiceAccount();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
            this.withImagePullSecrets(instance.getImagePullSecrets());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSecrets(instance.getSecrets());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return (A)this;
    }

    public boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    public A addToImagePullSecrets(int index, V1LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(index, builder);
        }
        return (A)this;
    }

    public A setToImagePullSecrets(int index, V1LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.set(index, builder);
        }
        return (A)this;
    }

    public A addToImagePullSecrets(V1LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    public A addAllToImagePullSecrets(Collection<V1LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    public A removeFromImagePullSecrets(V1LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromImagePullSecrets(Collection<V1LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromImagePullSecrets(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        Iterator<V1LocalObjectReferenceBuilder> each = this.imagePullSecrets.iterator();
        Object visitables = this._visitables.get("imagePullSecrets");
        while (each.hasNext()) {
            V1LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1LocalObjectReference> buildImagePullSecrets() {
        return this.imagePullSecrets != null ? V1ServiceAccountFluent.build(this.imagePullSecrets) : null;
    }

    public V1LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    public V1LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    public V1LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1).build();
    }

    public V1LocalObjectReference buildMatchingImagePullSecret(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        for (V1LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImagePullSecret(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        for (V1LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImagePullSecrets(List<V1LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get("imagePullSecrets").clear();
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList();
            for (V1LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)this;
    }

    public A withImagePullSecrets(V1LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
            this._visitables.remove("imagePullSecrets");
        }
        if (imagePullSecrets != null) {
            for (V1LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    public boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    public ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNested(-1, null);
    }

    public ImagePullSecretsNested<A> addNewImagePullSecretLike(V1LocalObjectReference item) {
        return new ImagePullSecretsNested(-1, item);
    }

    public ImagePullSecretsNested<A> setNewImagePullSecretLike(int index, V1LocalObjectReference item) {
        return new ImagePullSecretsNested(index, item);
    }

    public ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (this.imagePullSecrets.size() <= index) {
            throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (this.imagePullSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(0, this.buildImagePullSecret(0));
    }

    public ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = this.imagePullSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imagePullSecrets.size(); ++i) {
            if (!predicate.test(this.imagePullSecrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToSecrets(int index, V1ObjectReference item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.secrets.size()) {
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        } else {
            this._visitables.get("secrets").add(builder);
            this.secrets.add(index, builder);
        }
        return (A)this;
    }

    public A setToSecrets(int index, V1ObjectReference item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.secrets.size()) {
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        } else {
            this._visitables.get("secrets").add(builder);
            this.secrets.set(index, builder);
        }
        return (A)this;
    }

    public A addToSecrets(V1ObjectReference ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        for (V1ObjectReference item : items) {
            V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    public A addAllToSecrets(Collection<V1ObjectReference> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList();
        }
        for (V1ObjectReference item : items) {
            V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    public A removeFromSecrets(V1ObjectReference ... items) {
        if (this.secrets == null) {
            return (A)this;
        }
        for (V1ObjectReference item : items) {
            V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
            this._visitables.get("secrets").remove(builder);
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSecrets(Collection<V1ObjectReference> items) {
        if (this.secrets == null) {
            return (A)this;
        }
        for (V1ObjectReference item : items) {
            V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
            this._visitables.get("secrets").remove(builder);
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSecrets(Predicate<V1ObjectReferenceBuilder> predicate) {
        if (this.secrets == null) {
            return (A)this;
        }
        Iterator<V1ObjectReferenceBuilder> each = this.secrets.iterator();
        Object visitables = this._visitables.get("secrets");
        while (each.hasNext()) {
            V1ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ObjectReference> buildSecrets() {
        return this.secrets != null ? V1ServiceAccountFluent.build(this.secrets) : null;
    }

    public V1ObjectReference buildSecret(int index) {
        return this.secrets.get(index).build();
    }

    public V1ObjectReference buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    public V1ObjectReference buildLastSecret() {
        return this.secrets.get(this.secrets.size() - 1).build();
    }

    public V1ObjectReference buildMatchingSecret(Predicate<V1ObjectReferenceBuilder> predicate) {
        for (V1ObjectReferenceBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSecret(Predicate<V1ObjectReferenceBuilder> predicate) {
        for (V1ObjectReferenceBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSecrets(List<V1ObjectReference> secrets) {
        if (this.secrets != null) {
            this._visitables.get("secrets").clear();
        }
        if (secrets != null) {
            this.secrets = new ArrayList();
            for (V1ObjectReference item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)this;
    }

    public A withSecrets(V1ObjectReference ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
            this._visitables.remove("secrets");
        }
        if (secrets != null) {
            for (V1ObjectReference item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    public boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    public SecretsNested<A> addNewSecret() {
        return new SecretsNested(-1, null);
    }

    public SecretsNested<A> addNewSecretLike(V1ObjectReference item) {
        return new SecretsNested(-1, item);
    }

    public SecretsNested<A> setNewSecretLike(int index, V1ObjectReference item) {
        return new SecretsNested(index, item);
    }

    public SecretsNested<A> editSecret(int index) {
        if (this.secrets.size() <= index) {
            throw new RuntimeException("Can't edit secrets. Index exceeds size.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public SecretsNested<A> editFirstSecret() {
        if (this.secrets.size() == 0) {
            throw new RuntimeException("Can't edit first secrets. The list is empty.");
        }
        return this.setNewSecretLike(0, this.buildSecret(0));
    }

    public SecretsNested<A> editLastSecret() {
        int index = this.secrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secrets. The list is empty.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    public SecretsNested<A> editMatchingSecret(Predicate<V1ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secrets.size(); ++i) {
            if (!predicate.test(this.secrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secrets. No match found.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ServiceAccountFluent that = (V1ServiceAccountFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.automountServiceAccountToken, that.automountServiceAccountToken)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecrets, that.imagePullSecrets)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.secrets, that.secrets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.automountServiceAccountToken, this.imagePullSecrets, this.kind, this.metadata, this.secrets, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.automountServiceAccountToken != null) {
            sb.append("automountServiceAccountToken:");
            sb.append(this.automountServiceAccountToken + ",");
        }
        if (this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty()) {
            sb.append("imagePullSecrets:");
            sb.append(String.valueOf(this.imagePullSecrets) + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(String.valueOf(this.metadata) + ",");
        }
        if (this.secrets != null && !this.secrets.isEmpty()) {
            sb.append("secrets:");
            sb.append(this.secrets);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAutomountServiceAccountToken() {
        return this.withAutomountServiceAccountToken(true);
    }

    public class ImagePullSecretsNested<N>
    extends V1LocalObjectReferenceFluent<ImagePullSecretsNested<N>>
    implements Nested<N> {
        V1LocalObjectReferenceBuilder builder;
        int index;

        ImagePullSecretsNested(int index, V1LocalObjectReference item) {
            this.index = index;
            this.builder = new V1LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ServiceAccountFluent.this.setToImagePullSecrets(this.index, this.builder.build());
        }

        public N endImagePullSecret() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ServiceAccountFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class SecretsNested<N>
    extends V1ObjectReferenceFluent<SecretsNested<N>>
    implements Nested<N> {
        V1ObjectReferenceBuilder builder;
        int index;

        SecretsNested(int index, V1ObjectReference item) {
            this.index = index;
            this.builder = new V1ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ServiceAccountFluent.this.setToSecrets(this.index, this.builder.build());
        }

        public N endSecret() {
            return this.and();
        }
    }
}

