/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling.")
public class V1QuobyteVolumeSource {
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    @Nullable
    private String group;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    @Nullable
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_REGISTRY = "registry";
    @SerializedName(value="registry")
    @Nonnull
    private String registry;
    public static final String SERIALIZED_NAME_TENANT = "tenant";
    @SerializedName(value="tenant")
    @Nullable
    private String tenant;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    @Nullable
    private String user;
    public static final String SERIALIZED_NAME_VOLUME = "volume";
    @SerializedName(value="volume")
    @Nonnull
    private String volume;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1QuobyteVolumeSource group(@Nullable String group) {
        this.group = group;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="group to map volume access to Default is no group")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@Nullable String group) {
        this.group = group;
    }

    public V1QuobyteVolumeSource readOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1QuobyteVolumeSource registry(@Nonnull String registry) {
        this.registry = registry;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes")
    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(@Nonnull String registry) {
        this.registry = registry;
    }

    public V1QuobyteVolumeSource tenant(@Nullable String tenant) {
        this.tenant = tenant;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin")
    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(@Nullable String tenant) {
        this.tenant = tenant;
    }

    public V1QuobyteVolumeSource user(@Nullable String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="user to map volume access to Defaults to serivceaccount user")
    public String getUser() {
        return this.user;
    }

    public void setUser(@Nullable String user) {
        this.user = user;
    }

    public V1QuobyteVolumeSource volume(@Nonnull String volume) {
        this.volume = volume;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="volume is a string that references an already created Quobyte volume by name.")
    public String getVolume() {
        return this.volume;
    }

    public void setVolume(@Nonnull String volume) {
        this.volume = volume;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1QuobyteVolumeSource v1QuobyteVolumeSource = (V1QuobyteVolumeSource)o;
        return Objects.equals(this.group, v1QuobyteVolumeSource.group) && Objects.equals(this.readOnly, v1QuobyteVolumeSource.readOnly) && Objects.equals(this.registry, v1QuobyteVolumeSource.registry) && Objects.equals(this.tenant, v1QuobyteVolumeSource.tenant) && Objects.equals(this.user, v1QuobyteVolumeSource.user) && Objects.equals(this.volume, v1QuobyteVolumeSource.volume);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.readOnly, this.registry, this.tenant, this.user, this.volume);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1QuobyteVolumeSource {\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    registry: ").append(this.toIndentedString(this.registry)).append("\n");
        sb.append("    tenant: ").append(this.toIndentedString(this.tenant)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    volume: ").append(this.toIndentedString(this.volume)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1QuobyteVolumeSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1QuobyteVolumeSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_GROUP) != null && !jsonObj.get(SERIALIZED_NAME_GROUP).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GROUP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `group` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_REGISTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `registry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REGISTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TENANT) != null && !jsonObj.get(SERIALIZED_NAME_TENANT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TENANT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `tenant` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TENANT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USER) != null && !jsonObj.get(SERIALIZED_NAME_USER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_USER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `user` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USER).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_VOLUME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `volume` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME).toString()));
        }
    }

    public static V1QuobyteVolumeSource fromJson(String jsonString) throws IOException {
        return (V1QuobyteVolumeSource)JSON.getGson().fromJson(jsonString, V1QuobyteVolumeSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_GROUP);
        openapiFields.add(SERIALIZED_NAME_READ_ONLY);
        openapiFields.add(SERIALIZED_NAME_REGISTRY);
        openapiFields.add(SERIALIZED_NAME_TENANT);
        openapiFields.add(SERIALIZED_NAME_USER);
        openapiFields.add(SERIALIZED_NAME_VOLUME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_REGISTRY);
        openapiRequiredFields.add(SERIALIZED_NAME_VOLUME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1QuobyteVolumeSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1QuobyteVolumeSource.class));
            return new TypeAdapter<V1QuobyteVolumeSource>(){

                public void write(JsonWriter out, V1QuobyteVolumeSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1QuobyteVolumeSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1QuobyteVolumeSource.validateJsonElement(jsonElement);
                    return (V1QuobyteVolumeSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

