/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1NodeSelectorTerm;
import io.kubernetes.client.openapi.models.V1NodeSelectorTermBuilder;
import io.kubernetes.client.openapi.models.V1NodeSelectorTermFluent;
import io.kubernetes.client.openapi.models.V1PreferredSchedulingTerm;
import java.util.Objects;
import java.util.Optional;

public class V1PreferredSchedulingTermFluent<A extends V1PreferredSchedulingTermFluent<A>>
extends BaseFluent<A> {
    private V1NodeSelectorTermBuilder preference;
    private Integer weight;

    public V1PreferredSchedulingTermFluent() {
    }

    public V1PreferredSchedulingTermFluent(V1PreferredSchedulingTerm instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1PreferredSchedulingTerm instance) {
        V1PreferredSchedulingTerm v1PreferredSchedulingTerm = instance = instance != null ? instance : new V1PreferredSchedulingTerm();
        if (instance != null) {
            this.withPreference(instance.getPreference());
            this.withWeight(instance.getWeight());
        }
    }

    public V1NodeSelectorTerm buildPreference() {
        return this.preference != null ? this.preference.build() : null;
    }

    public A withPreference(V1NodeSelectorTerm preference) {
        this._visitables.remove("preference");
        if (preference != null) {
            this.preference = new V1NodeSelectorTermBuilder(preference);
            this._visitables.get("preference").add(this.preference);
        } else {
            this.preference = null;
            this._visitables.get("preference").remove(this.preference);
        }
        return (A)this;
    }

    public boolean hasPreference() {
        return this.preference != null;
    }

    public PreferenceNested<A> withNewPreference() {
        return new PreferenceNested(null);
    }

    public PreferenceNested<A> withNewPreferenceLike(V1NodeSelectorTerm item) {
        return new PreferenceNested(item);
    }

    public PreferenceNested<A> editPreference() {
        return this.withNewPreferenceLike(Optional.ofNullable(this.buildPreference()).orElse(null));
    }

    public PreferenceNested<A> editOrNewPreference() {
        return this.withNewPreferenceLike(Optional.ofNullable(this.buildPreference()).orElse(new V1NodeSelectorTermBuilder().build()));
    }

    public PreferenceNested<A> editOrNewPreferenceLike(V1NodeSelectorTerm item) {
        return this.withNewPreferenceLike(Optional.ofNullable(this.buildPreference()).orElse(item));
    }

    public Integer getWeight() {
        return this.weight;
    }

    public A withWeight(Integer weight) {
        this.weight = weight;
        return (A)this;
    }

    public boolean hasWeight() {
        return this.weight != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PreferredSchedulingTermFluent that = (V1PreferredSchedulingTermFluent)o;
        if (!Objects.equals(this.preference, that.preference)) {
            return false;
        }
        return Objects.equals(this.weight, that.weight);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.preference, this.weight, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.preference != null) {
            sb.append("preference:");
            sb.append(String.valueOf(this.preference) + ",");
        }
        if (this.weight != null) {
            sb.append("weight:");
            sb.append(this.weight);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PreferenceNested<N>
    extends V1NodeSelectorTermFluent<PreferenceNested<N>>
    implements Nested<N> {
        V1NodeSelectorTermBuilder builder;

        PreferenceNested(V1NodeSelectorTerm item) {
            this.builder = new V1NodeSelectorTermBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PreferredSchedulingTermFluent.this.withPreference(this.builder.build());
        }

        public N endPreference() {
            return this.and();
        }
    }
}

